/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="This element is used to configure language detection and the representation of syntax elements in recognized programming/script languages.")
@JsonPropertyOrder(value={"available", "fontFamily", "fontOrigin", "fontSize", "language", "lineHeight", "lineNumbers", "relevance", "wordBreak"})
@JsonTypeName(value="Operation_SyntaxHighlight")
public class OperationSyntaxHighlight {
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private String available = "";
    public static final String JSON_PROPERTY_FONT_FAMILY = "fontFamily";
    private String fontFamily = "";
    public static final String JSON_PROPERTY_FONT_ORIGIN = "fontOrigin";
    private FontOriginEnum fontOrigin = FontOriginEnum.SYSTEM;
    public static final String JSON_PROPERTY_FONT_SIZE = "fontSize";
    private String fontSize = "10px";
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language = "";
    public static final String JSON_PROPERTY_LINE_HEIGHT = "lineHeight";
    private String lineHeight = "12px";
    public static final String JSON_PROPERTY_LINE_NUMBERS = "lineNumbers";
    private Boolean lineNumbers = true;
    public static final String JSON_PROPERTY_RELEVANCE = "relevance";
    private Integer relevance = 90;
    public static final String JSON_PROPERTY_WORD_BREAK = "wordBreak";
    private WordBreakEnum wordBreak = WordBreakEnum.AUTO;

    public OperationSyntaxHighlight available(String available) {
        this.available = available;
        return this;
    }

    @Schema(name="Can be used to specify the languages to which the syntax highlighted should be limited. You can enter multiple languages by separating them with a comma (\"java,cpp\"). If you do not specify a value, all the languages listed below will be recognized. You can select any of the following languages:  *   abnf = Augmented Backus-Naur form *   accesslog = Apache/Nginx Access Logs *   actionscript = ActionScript *   ada = Ada *   angelscript = AngelScript *   apache = Apache configuration language *   applescript = AppleScript *   arcade = ArcGIS Arcade *   arduino = Arduino *   armasm = ARM Assembly *   asciidoc = AsciiDoc *   aspectj = AspectJ *   autohotkey = AutoHotkey *   autoit = AutoIt *   avrasm = AVR Assembler *   awk = Awk *   axapta = Axapta *   bash = Bash *   basic = Basic *   bnf = Backus-Naur Form *   brainfuck = Brainfuck *   cal = C/AL *   capnproto = Cap'n Proto *   ceylon = Ceylon *   clean = Clean *   clojure-repl = Clojure REPL *   clojure = Clojure *   cmake = CMake *   coffeescript = CoffeeScript *   coq = Coq *   cos = Cach\u00e9 Object Script *   cpp = C++ *   crmsh = crmsh *   crystal = Crystal *   cs = C# *   csp = CSP *   css = CSS *   d = D *   dart = Dart *   delphi = Delphi *   diff = Diff *   django = Django *   dns = DNS Zone file *   dockerfile = Dockerfile *   dos = DOS .bat *   dsconfig = dsconfig *   dts = Device Tree *   dust = Dust *   ebnf = Extended Backus-Naur Form *   elixir = Elixir *   elm = Elm *   erb = Embedded Ruby *   erlang-repl = Erlang REPL *   erlang = Erlang *   excel = Excel *   fix = FIX *   flix = FLIX *   fortran = Fortran *   fsharp = F# *   gams = GAMS *   gauss = GAUSS *   gcode = G-code *   gherkin = Gherkin *   glsl = GLSL *   gml = GML *   go = Go *   golo = Golo *   gradle = Gradle *   groovy = Groovy *   haml = Haml *   arduino = Arduino *   handlebars = Handlebars *   haskell = Haskell *   haxe = Haxe *   hsp = HSP *   htmlbars = HTMLBars *   http = HTTP *   hy = Hy *   inform7 = Inform 7 *   arduino = Ini, TOML *   irpf90 = IRPF90 *   isbl = ISBL *   java = Java *   javascript = Javascript *   jboss-cli = jboss-cli *   json = JSON *   julia-repl = Julia REPL *   julia = Julia *   kotlin = Kotlin *   lasso = Lasso *   ldif = LDIF *   leaf = Leaf *   less = Less *   lisp = Lisp *   livecodeserver = LiveCode *   livescript = LiveScript *   llvm = LLVM IR *   lsl = Linden Scripting Language *   lua = Lua *   makefile = Makefile *   markdown = Markdown *   mathematica = Mathematica *   matlab = Matlab *   maxima = Maxima *   mel = MEL *   mercury = Mercury *   mipsasm = MIPS Assembly *   mizar = Mizar *   mojolicious = Mojolicious *   monkey = Monkey *   moonscript = MoonScript *   n1ql = N1QL *   nginx = Nginx *   nimrod = Nimrod *   nix = Nix *   nsis = NSIS *   objectivec = Objective-C *   ocaml = OCaml *   openscad = OpenSCAD *   oxygene = Oxygene *   parser3 = Parser3 *   perl = Perl *   pf = pf *   pgsql = PostgreSQL *   php = PHP *   plaintext = plaintext *   pony = Pony *   powershell = PowerShell *   processing = Processing *   profile = Python profile *   prolog = Prolog *   properties = Properties *   protobuf = Protocol Buffers *   puppet = Puppet *   purebasic = PureBASIC *   python = Python *   q = Q *   qml = QML *   r = R *   reasonml = ReasonML *   rib = RenderMan RIB *   roboconf = Roboconf *   routeros = Microtik RouterOS Script *   rsl = RenderMan RSL *   ruby = Ruby *   ruleslanguage = Oracle Rules Language *   rust = Rust *   sas = SAS *   scala = Scala *   scheme = Scheme *   scilab = Scilab *   scss = SCSS *   shell = Shell Session *   smali = Smali *   smalltalk = Smalltalk *   sml = SML *   sqf = SQF *   sql = SQL *   stan = Stan *   stata = Stata *   step21 = Step Part 21 *   stylus = Stylus *   subunit = SubUnit *   swift = Swift *   taggerscript = Tagger Script *   tap = Test Anything Protocol *   tcl = Tcl *   tex = TeX *   thrift = Thrift *   tp = TP *   twig = Twig *   typescript = TypeScript *   vala = Vala *   vbnet = VB.NET *   vbscript-html = VBScript in HTML *   vbscript = VBScript *   verilog = Verilog *   vhdl = VHDL *   vim = Vim Script *   x86asm = Intel x86 Assembly *   xl = XL *   xml = XML *   xquery = XQuery *   yaml = YAML *   zephir = Zephir")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(String available) {
        this.available = available;
    }

    public OperationSyntaxHighlight fontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    @Schema(name="Used to specify the font that should be used for syntax highlighting. If you select \"folder\" for the \"fontOrigin\" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the \"Fira Code\" font will be used automatically.")
    @JsonProperty(value="fontFamily")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFontFamily() {
        return this.fontFamily;
    }

    @JsonProperty(value="fontFamily")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public OperationSyntaxHighlight fontOrigin(FontOriginEnum fontOrigin) {
        this.fontOrigin = fontOrigin;
        return this;
    }

    @Schema(name="Used to specify whether the selected font should be obtained from your operating system or from the \"templates/fonts\" folder (in your webPDF installation path). Possible values:  *   system = It will be possible to select from the fonts available system-wide. *   folder =It will be possible to select from the fonts in \"templates/fonts\".")
    @JsonProperty(value="fontOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FontOriginEnum getFontOrigin() {
        return this.fontOrigin;
    }

    @JsonProperty(value="fontOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontOrigin(FontOriginEnum fontOrigin) {
        this.fontOrigin = fontOrigin;
    }

    public OperationSyntaxHighlight fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Schema(name="Used to set the font size for syntax highlighting to the specified value. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
    @JsonProperty(value="fontSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFontSize() {
        return this.fontSize;
    }

    @JsonProperty(value="fontSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public OperationSyntaxHighlight language(String language) {
        this.language = language;
        return this;
    }

    @Schema(name="Used to select a specific language for highlighting recognition. You can select one of the languages listed for the \"available\" parameter. If you do not set this value, the system will attempt to automatically select an appropriate language from the list of available languages.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public OperationSyntaxHighlight lineHeight(String lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    @Schema(name="Used to set the line height. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
    @JsonProperty(value="lineHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLineHeight() {
        return this.lineHeight;
    }

    @JsonProperty(value="lineHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineHeight(String lineHeight) {
        this.lineHeight = lineHeight;
    }

    public OperationSyntaxHighlight lineNumbers(Boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
        return this;
    }

    @Schema(name="If this value is set to \"true\", line numbers are added before the code.")
    @JsonProperty(value="lineNumbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLineNumbers() {
        return this.lineNumbers;
    }

    @JsonProperty(value="lineNumbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineNumbers(Boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public OperationSyntaxHighlight relevance(Integer relevance) {
        this.relevance = relevance;
        return this;
    }

    @Schema(name="The syntax highlighter evaluates the degree of reliability with which it recognizes a language with a value ranging from 0 to 1000 points. This value determines the reliability level starting from which it should highlight syntax for a recognized language. The higher the value, the more closely the content found must match the criteria.")
    @JsonProperty(value="relevance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRelevance() {
        return this.relevance;
    }

    @JsonProperty(value="relevance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelevance(Integer relevance) {
        this.relevance = relevance;
    }

    public OperationSyntaxHighlight wordBreak(WordBreakEnum wordBreak) {
        this.wordBreak = wordBreak;
        return this;
    }

    @Schema(name="Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto = Automatic word wrap if necessary. *   none = Suppress the addition of extra line breaks. *   word = Line breaks allowed only after words. *   all = Line breaks allowed unconditionally.")
    @JsonProperty(value="wordBreak")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public WordBreakEnum getWordBreak() {
        return this.wordBreak;
    }

    @JsonProperty(value="wordBreak")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWordBreak(WordBreakEnum wordBreak) {
        this.wordBreak = wordBreak;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSyntaxHighlight operationSyntaxHighlight = (OperationSyntaxHighlight)o;
        return Objects.equals(this.available, operationSyntaxHighlight.available) && Objects.equals(this.fontFamily, operationSyntaxHighlight.fontFamily) && Objects.equals((Object)this.fontOrigin, (Object)operationSyntaxHighlight.fontOrigin) && Objects.equals(this.fontSize, operationSyntaxHighlight.fontSize) && Objects.equals(this.language, operationSyntaxHighlight.language) && Objects.equals(this.lineHeight, operationSyntaxHighlight.lineHeight) && Objects.equals(this.lineNumbers, operationSyntaxHighlight.lineNumbers) && Objects.equals(this.relevance, operationSyntaxHighlight.relevance) && Objects.equals((Object)this.wordBreak, (Object)operationSyntaxHighlight.wordBreak);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.available, this.fontFamily, this.fontOrigin, this.fontSize, this.language, this.lineHeight, this.lineNumbers, this.relevance, this.wordBreak});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSyntaxHighlight {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    fontFamily: ").append(this.toIndentedString(this.fontFamily)).append("\n");
        sb.append("    fontOrigin: ").append(this.toIndentedString((Object)this.fontOrigin)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineHeight: ").append(this.toIndentedString(this.lineHeight)).append("\n");
        sb.append("    lineNumbers: ").append(this.toIndentedString(this.lineNumbers)).append("\n");
        sb.append("    relevance: ").append(this.toIndentedString(this.relevance)).append("\n");
        sb.append("    wordBreak: ").append(this.toIndentedString((Object)this.wordBreak)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum WordBreakEnum {
        AUTO("auto"),
        NONE("none"),
        WORD("word"),
        ALL("all");

        private String value;

        private WordBreakEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WordBreakEnum fromValue(String value) {
            for (WordBreakEnum b : WordBreakEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FontOriginEnum {
        SYSTEM("system"),
        FOLDER("folder");

        private String value;

        private FontOriginEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FontOriginEnum fromValue(String value) {
            for (FontOriginEnum b : FontOriginEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

