/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="When activated, the goToThread action jumps to a specific thread defined in the document.")
@JsonPropertyOrder(value={"beadIndex", "page", "threadIndex", "threadTitle"})
@JsonTypeName(value="Operation_ThreadAction_goToThread")
public class OperationThreadActionGoToThread {
    public static final String JSON_PROPERTY_BEAD_INDEX = "beadIndex";
    private Integer beadIndex = 0;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_THREAD_INDEX = "threadIndex";
    private Integer threadIndex = 0;
    public static final String JSON_PROPERTY_THREAD_TITLE = "threadTitle";
    private String threadTitle = "";

    public OperationThreadActionGoToThread beadIndex(Integer beadIndex) {
        this.beadIndex = beadIndex;
        return this;
    }

    @Schema(name="The index of the thread section to which the jump should be. This value is optional and does not need to be specified.")
    @JsonProperty(value="beadIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getBeadIndex() {
        return this.beadIndex;
    }

    @JsonProperty(value="beadIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBeadIndex(Integer beadIndex) {
        this.beadIndex = beadIndex;
    }

    public OperationThreadActionGoToThread page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The page number of the page where the thread is found.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationThreadActionGoToThread threadIndex(Integer threadIndex) {
        this.threadIndex = threadIndex;
        return this;
    }

    @Schema(name="The index of the thread in the document's thread directory to which the jump should be. This value is an alternative to \"threadTitle\" and does not have to be set if the latter has been specified.")
    @JsonProperty(value="threadIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getThreadIndex() {
        return this.threadIndex;
    }

    @JsonProperty(value="threadIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreadIndex(Integer threadIndex) {
        this.threadIndex = threadIndex;
    }

    public OperationThreadActionGoToThread threadTitle(String threadTitle) {
        this.threadTitle = threadTitle;
        return this;
    }

    @Schema(name="The title of the thread to which the jump should be. This value is an alternative to \"threadIndex\" and does not have to be set if the latter has been specified.")
    @JsonProperty(value="threadTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getThreadTitle() {
        return this.threadTitle;
    }

    @JsonProperty(value="threadTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreadTitle(String threadTitle) {
        this.threadTitle = threadTitle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationThreadActionGoToThread operationThreadActionGoToThread = (OperationThreadActionGoToThread)o;
        return Objects.equals(this.beadIndex, operationThreadActionGoToThread.beadIndex) && Objects.equals(this.page, operationThreadActionGoToThread.page) && Objects.equals(this.threadIndex, operationThreadActionGoToThread.threadIndex) && Objects.equals(this.threadTitle, operationThreadActionGoToThread.threadTitle);
    }

    public int hashCode() {
        return Objects.hash(this.beadIndex, this.page, this.threadIndex, this.threadTitle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationThreadActionGoToThread {\n");
        sb.append("    beadIndex: ").append(this.toIndentedString(this.beadIndex)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    threadIndex: ").append(this.toIndentedString(this.threadIndex)).append("\n");
        sb.append("    threadTitle: ").append(this.toIndentedString(this.threadTitle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

