/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationXmpFileData;
import net.webpdf.wsclient.openapi.OperationXmpNamespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="The xmp operation element can be used to add XMP metadata to the document.")
@JsonPropertyOrder(value={"data", "dataFormat", "namespace"})
@JsonTypeName(value="Operation_ToolboxXmp_xmp")
public class OperationToolboxXmpXmp {
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationXmpFileData data;
    public static final String JSON_PROPERTY_DATA_FORMAT = "dataFormat";
    private DataFormatEnum dataFormat = DataFormatEnum.JSON;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private OperationXmpNamespace namespace;

    public OperationToolboxXmpXmp data(OperationXmpFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationXmpFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationXmpFileData data) {
        this.data = data;
    }

    public OperationToolboxXmpXmp dataFormat(DataFormatEnum dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    @Schema(name="Format for the XMP metadata being added. As of this writing, only \"json\" is supported.")
    @JsonProperty(value="dataFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DataFormatEnum getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty(value="dataFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataFormat(DataFormatEnum dataFormat) {
        this.dataFormat = dataFormat;
    }

    public OperationToolboxXmpXmp namespace(OperationXmpNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationXmpNamespace getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNamespace(OperationXmpNamespace namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxXmpXmp operationToolboxXmpXmp = (OperationToolboxXmpXmp)o;
        return Objects.equals(this.data, operationToolboxXmpXmp.data) && Objects.equals((Object)this.dataFormat, (Object)operationToolboxXmpXmp.dataFormat) && Objects.equals(this.namespace, operationToolboxXmpXmp.namespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.dataFormat, this.namespace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxXmpXmp {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    dataFormat: ").append(this.toIndentedString((Object)this.dataFormat)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DataFormatEnum {
        JSON("json"),
        XML("xml");

        private String value;

        private DataFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DataFormatEnum fromValue(String value) {
            for (DataFormatEnum b : DataFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

