/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to set the namespace for XMP metadata.")
@JsonPropertyOrder(value={"namespaceName", "namespacePrefix", "namespaceURI"})
@JsonTypeName(value="Operation_XmpNamespace")
public class OperationXmpNamespace {
    public static final String JSON_PROPERTY_NAMESPACE_NAME = "namespaceName";
    private String namespaceName = "";
    public static final String JSON_PROPERTY_NAMESPACE_PREFIX = "namespacePrefix";
    private String namespacePrefix = "";
    public static final String JSON_PROPERTY_NAMESPACE_U_R_I = "namespaceURI";
    private String namespaceURI = "";

    public OperationXmpNamespace namespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
        return this;
    }

    @Schema(name="Sets the namespace for the XMP data (e.g. \"webPDF XMP Properties\")")
    @JsonProperty(value="namespaceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @JsonProperty(value="namespaceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public OperationXmpNamespace namespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
        return this;
    }

    @Schema(name="Sets the prefix for the XMP data (e.g. \"webpdf\")")
    @JsonProperty(value="namespacePrefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @JsonProperty(value="namespacePrefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public OperationXmpNamespace namespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
        return this;
    }

    @Schema(name="Sets the URI for the XMP data (e.g. \"http://ns.webpdf.de/webpdf/6.0/\")")
    @JsonProperty(value="namespaceURI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @JsonProperty(value="namespaceURI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationXmpNamespace operationXmpNamespace = (OperationXmpNamespace)o;
        return Objects.equals(this.namespaceName, operationXmpNamespace.namespaceName) && Objects.equals(this.namespacePrefix, operationXmpNamespace.namespacePrefix) && Objects.equals(this.namespaceURI, operationXmpNamespace.namespaceURI);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceName, this.namespacePrefix, this.namespaceURI);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationXmpNamespace {\n");
        sb.append("    namespaceName: ").append(this.toIndentedString(this.namespaceName)).append("\n");
        sb.append("    namespacePrefix: ").append(this.toIndentedString(this.namespacePrefix)).append("\n");
        sb.append("    namespaceURI: ").append(this.toIndentedString(this.namespaceURI)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

