/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigConnectorConfiguration;
import net.webpdf.wsclient.openapi.ServerConfigProxy;
import net.webpdf.wsclient.openapi.ServerConfigSSL;
import org.jetbrains.annotations.Nullable;

@Schema(description="A [connector](https://tomcat.apache.org/tomcat-9.0-doc/config/http.html) defines the properties of a port the server can be accessed by.")
@JsonPropertyOrder(value={"address", "compressibleMimeType", "compression", "compressionMinSize", "configuration", "enabled", "port", "protocol", "proxy", "ssl"})
@JsonTypeName(value="ServerConfig_Connector")
public class ServerConfigConnector {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address = "";
    public static final String JSON_PROPERTY_COMPRESSIBLE_MIME_TYPE = "compressibleMimeType";
    private String compressibleMimeType = "text/html,text/xml,text/css,application/json,application/javascript";
    public static final String JSON_PROPERTY_COMPRESSION = "compression";
    private CompressionEnum compression = CompressionEnum.ON;
    public static final String JSON_PROPERTY_COMPRESSION_MIN_SIZE = "compressionMinSize";
    private Integer compressionMinSize = 2048;
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private ServerConfigConnectorConfiguration _configuration;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port = 8080;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private ProtocolEnum protocol = ProtocolEnum.HTTP_1_1;
    public static final String JSON_PROPERTY_PROXY = "proxy";
    private ServerConfigProxy proxy;
    public static final String JSON_PROPERTY_SSL = "ssl";
    private ServerConfigSSL ssl;

    public ServerConfigConnector address(String address) {
        this.address = address;
        return this;
    }

    @Schema(name="The IP address to which the port should listen.")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public ServerConfigConnector compressibleMimeType(String compressibleMimeType) {
        this.compressibleMimeType = compressibleMimeType;
        return this;
    }

    @Schema(name="Selects the MIME Types of message contents, that may be compressed via GZIP compression.")
    @JsonProperty(value="compressibleMimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCompressibleMimeType() {
        return this.compressibleMimeType;
    }

    @JsonProperty(value="compressibleMimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompressibleMimeType(String compressibleMimeType) {
        this.compressibleMimeType = compressibleMimeType;
    }

    public ServerConfigConnector compression(CompressionEnum compression) {
        this.compression = compression;
        return this;
    }

    @Schema(name="Specifies whether to apply GZIP compression to the message to save bandwidth.  *   off = disable compression. *   on = allow compression, which causes text data to be compressed. *   force = forces compression in all cases.")
    @JsonProperty(value="compression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CompressionEnum getCompression() {
        return this.compression;
    }

    @JsonProperty(value="compression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompression(CompressionEnum compression) {
        this.compression = compression;
    }

    public ServerConfigConnector compressionMinSize(Integer compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
        return this;
    }

    @Schema(name="Sets the minimum amount of bytes a message must reach before GZIP compression shall be applied.")
    @JsonProperty(value="compressionMinSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getCompressionMinSize() {
        return this.compressionMinSize;
    }

    @JsonProperty(value="compressionMinSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompressionMinSize(Integer compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public ServerConfigConnector _configuration(ServerConfigConnectorConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigConnectorConfiguration getConfiguration() {
        return this._configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(ServerConfigConnectorConfiguration _configuration) {
        this._configuration = _configuration;
    }

    public ServerConfigConnector enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="When set to true this connector is active and may be used to connect to the server.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ServerConfigConnector port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="The port the connector is listening to.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public ServerConfigConnector protocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    @Schema(name="The protocol to use for a connector.  *   HTTP/1.1 = Non blocking java NIO connector. *   HTTP/2.0 = Non blocking java NIO2 connector. *   AJP/1.3 = The APR/native connector.")
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public ServerConfigConnector proxy(ServerConfigProxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="proxy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigProxy getProxy() {
        return this.proxy;
    }

    @JsonProperty(value="proxy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProxy(ServerConfigProxy proxy) {
        this.proxy = proxy;
    }

    public ServerConfigConnector ssl(ServerConfigSSL ssl) {
        this.ssl = ssl;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="ssl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigSSL getSsl() {
        return this.ssl;
    }

    @JsonProperty(value="ssl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSsl(ServerConfigSSL ssl) {
        this.ssl = ssl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigConnector serverConfigConnector = (ServerConfigConnector)o;
        return Objects.equals(this.address, serverConfigConnector.address) && Objects.equals(this.compressibleMimeType, serverConfigConnector.compressibleMimeType) && Objects.equals((Object)this.compression, (Object)serverConfigConnector.compression) && Objects.equals(this.compressionMinSize, serverConfigConnector.compressionMinSize) && Objects.equals(this._configuration, serverConfigConnector._configuration) && Objects.equals(this.enabled, serverConfigConnector.enabled) && Objects.equals(this.port, serverConfigConnector.port) && Objects.equals((Object)this.protocol, (Object)serverConfigConnector.protocol) && Objects.equals(this.proxy, serverConfigConnector.proxy) && Objects.equals(this.ssl, serverConfigConnector.ssl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.compressibleMimeType, this.compression, this.compressionMinSize, this._configuration, this.enabled, this.port, this.protocol, this.proxy, this.ssl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigConnector {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    compressibleMimeType: ").append(this.toIndentedString(this.compressibleMimeType)).append("\n");
        sb.append("    compression: ").append(this.toIndentedString((Object)this.compression)).append("\n");
        sb.append("    compressionMinSize: ").append(this.toIndentedString(this.compressionMinSize)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    proxy: ").append(this.toIndentedString(this.proxy)).append("\n");
        sb.append("    ssl: ").append(this.toIndentedString(this.ssl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProtocolEnum {
        HTTP_1_1("HTTP/1.1"),
        HTTP_2_0("HTTP/2.0"),
        AJP_1_3("AJP/1.3");

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CompressionEnum {
        ON("on"),
        OFF("off"),
        FORCE("force");

        private String value;

        private CompressionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompressionEnum fromValue(String value) {
            for (CompressionEnum b : CompressionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

