/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigOAuthProviderLogout;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines an Oauth2 authorization provider.")
@JsonPropertyOrder(value={"applicationId", "claimClientId", "claimRoles", "claimSessionId", "clientId", "discoveryUrl", "displayName", "flow", "id", "logout", "maxTimeSkew", "name", "roleNameAdmin", "roleNameUser", "scope", "tenantId"})
@JsonTypeName(value="ServerConfig_OAuthProvider")
public class ServerConfigOAuthProvider {
    public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
    private String applicationId = "";
    public static final String JSON_PROPERTY_CLAIM_CLIENT_ID = "claimClientId";
    private String claimClientId = "";
    public static final String JSON_PROPERTY_CLAIM_ROLES = "claimRoles";
    private String claimRoles = "";
    public static final String JSON_PROPERTY_CLAIM_SESSION_ID = "claimSessionId";
    private String claimSessionId = "";
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId = "";
    public static final String JSON_PROPERTY_DISCOVERY_URL = "discoveryUrl";
    private String discoveryUrl = "";
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName = "";
    public static final String JSON_PROPERTY_FLOW = "flow";
    private FlowEnum flow = FlowEnum.CLIENTCREDENTIALS;
    public static final String JSON_PROPERTY_ID = "id";
    private String id = "";
    public static final String JSON_PROPERTY_LOGOUT = "logout";
    private ServerConfigOAuthProviderLogout logout;
    public static final String JSON_PROPERTY_MAX_TIME_SKEW = "maxTimeSkew";
    private Integer maxTimeSkew = 0;
    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name = NameEnum.GENERIC;
    public static final String JSON_PROPERTY_ROLE_NAME_ADMIN = "roleNameAdmin";
    private String roleNameAdmin = "";
    public static final String JSON_PROPERTY_ROLE_NAME_USER = "roleNameUser";
    private String roleNameUser = "";
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope = "";
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId = "";

    public ServerConfigOAuthProvider applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Schema(name="Sets the application identifier that uniquely identifies the application (the API of this server). This ID is also defined as the audience for the token to verify that the token was issued for the API dServer.")
    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="applicationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ServerConfigOAuthProvider claimClientId(String claimClientId) {
        this.claimClientId = claimClientId;
        return this;
    }

    @Schema(name="Sets the name of the claim (in most cases \"azp\") that contains the client ID in the token.")
    @JsonProperty(value="claimClientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClaimClientId() {
        return this.claimClientId;
    }

    @JsonProperty(value="claimClientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaimClientId(String claimClientId) {
        this.claimClientId = claimClientId;
    }

    public ServerConfigOAuthProvider claimRoles(String claimRoles) {
        this.claimRoles = claimRoles;
        return this;
    }

    @Schema(name="Sets the name of the claim (in most cases \"roles\") that contains the roles in the token.")
    @JsonProperty(value="claimRoles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClaimRoles() {
        return this.claimRoles;
    }

    @JsonProperty(value="claimRoles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaimRoles(String claimRoles) {
        this.claimRoles = claimRoles;
    }

    public ServerConfigOAuthProvider claimSessionId(String claimSessionId) {
        this.claimSessionId = claimSessionId;
        return this;
    }

    @Schema(name="Specifies the name of the claim (in most cases \"sub\") that contains the session ID in the token. This must be a unique identifier that uniquely identifies the authenticated client (or user).")
    @JsonProperty(value="claimSessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClaimSessionId() {
        return this.claimSessionId;
    }

    @JsonProperty(value="claimSessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaimSessionId(String claimSessionId) {
        this.claimSessionId = claimSessionId;
    }

    public ServerConfigOAuthProvider clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(name="Sets the [OAuth2 client identifier](https://datatracker.ietf.org/doc/html/rfc6749#section-2.2).")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ServerConfigOAuthProvider discoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
        return this;
    }

    @Schema(name="Sets the [discovery URL](https://datatracker.ietf.org/doc/html/rfc8414) for the OAuth2 process, where the server can find, for example, the required public signature keys for token validation.")
    @JsonProperty(value="discoveryUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    @JsonProperty(value="discoveryUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public ServerConfigOAuthProvider displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(name="The displayed name for the provider (e.g. in the portal).")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ServerConfigOAuthProvider flow(FlowEnum flow) {
        this.flow = flow;
        return this;
    }

    @Schema(name="Selects the [OAuth2 flow](https://datatracker.ietf.org/doc/html/rfc6749#section-1.2) used. Depending on the flow, different settings are necessary for the provider.")
    @JsonProperty(value="flow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FlowEnum getFlow() {
        return this.flow;
    }

    @JsonProperty(value="flow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlow(FlowEnum flow) {
        this.flow = flow;
    }

    public ServerConfigOAuthProvider id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="Sets a unique ID that uniquely identifies this provider configuration.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ServerConfigOAuthProvider logout(ServerConfigOAuthProviderLogout logout) {
        this.logout = logout;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="logout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigOAuthProviderLogout getLogout() {
        return this.logout;
    }

    @JsonProperty(value="logout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogout(ServerConfigOAuthProviderLogout logout) {
        this.logout = logout;
    }

    public ServerConfigOAuthProvider maxTimeSkew(Integer maxTimeSkew) {
        this.maxTimeSkew = maxTimeSkew;
        return this;
    }

    @Schema(name="The maximum time skew that may occur between the local time on the server and the local time of the issuer of the token.")
    @JsonProperty(value="maxTimeSkew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxTimeSkew() {
        return this.maxTimeSkew;
    }

    @JsonProperty(value="maxTimeSkew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxTimeSkew(Integer maxTimeSkew) {
        this.maxTimeSkew = maxTimeSkew;
    }

    public ServerConfigOAuthProvider name(NameEnum name) {
        this.name = name;
        return this;
    }

    @Schema(name="Selects the OAuth2 provider or \"generic\", when not available in the list.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public NameEnum getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public ServerConfigOAuthProvider roleNameAdmin(String roleNameAdmin) {
        this.roleNameAdmin = roleNameAdmin;
        return this;
    }

    @Schema(name="Sets the name of the role that grants administrative rights. This allows changing the default \"admin\" value to a custom role name. This must match the content of the claim defined via \"claimRoles\".")
    @JsonProperty(value="roleNameAdmin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRoleNameAdmin() {
        return this.roleNameAdmin;
    }

    @JsonProperty(value="roleNameAdmin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleNameAdmin(String roleNameAdmin) {
        this.roleNameAdmin = roleNameAdmin;
    }

    public ServerConfigOAuthProvider roleNameUser(String roleNameUser) {
        this.roleNameUser = roleNameUser;
        return this;
    }

    @Schema(name="Sets the name of the role that grants normal user rights. This allows changing the default \"user\" value to a custom role name. This must match the content of the claim defined via \"claimRoles\".")
    @JsonProperty(value="roleNameUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRoleNameUser() {
        return this.roleNameUser;
    }

    @JsonProperty(value="roleNameUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleNameUser(String roleNameUser) {
        this.roleNameUser = roleNameUser;
    }

    public ServerConfigOAuthProvider scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Schema(name="Specifies the [scope](https://datatracker.ietf.org/doc/html/rfc6749#page-23) for the OAuth2 token. Each separated by a space.")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public ServerConfigOAuthProvider tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Schema(name="Sets a tenant identifier for the OAuth2 request. Not all providers require a tenant id.")
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigOAuthProvider serverConfigOAuthProvider = (ServerConfigOAuthProvider)o;
        return Objects.equals(this.applicationId, serverConfigOAuthProvider.applicationId) && Objects.equals(this.claimClientId, serverConfigOAuthProvider.claimClientId) && Objects.equals(this.claimRoles, serverConfigOAuthProvider.claimRoles) && Objects.equals(this.claimSessionId, serverConfigOAuthProvider.claimSessionId) && Objects.equals(this.clientId, serverConfigOAuthProvider.clientId) && Objects.equals(this.discoveryUrl, serverConfigOAuthProvider.discoveryUrl) && Objects.equals(this.displayName, serverConfigOAuthProvider.displayName) && Objects.equals((Object)this.flow, (Object)serverConfigOAuthProvider.flow) && Objects.equals(this.id, serverConfigOAuthProvider.id) && Objects.equals(this.logout, serverConfigOAuthProvider.logout) && Objects.equals(this.maxTimeSkew, serverConfigOAuthProvider.maxTimeSkew) && Objects.equals((Object)this.name, (Object)serverConfigOAuthProvider.name) && Objects.equals(this.roleNameAdmin, serverConfigOAuthProvider.roleNameAdmin) && Objects.equals(this.roleNameUser, serverConfigOAuthProvider.roleNameUser) && Objects.equals(this.scope, serverConfigOAuthProvider.scope) && Objects.equals(this.tenantId, serverConfigOAuthProvider.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationId, this.claimClientId, this.claimRoles, this.claimSessionId, this.clientId, this.discoveryUrl, this.displayName, this.flow, this.id, this.logout, this.maxTimeSkew, this.name, this.roleNameAdmin, this.roleNameUser, this.scope, this.tenantId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigOAuthProvider {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    claimClientId: ").append(this.toIndentedString(this.claimClientId)).append("\n");
        sb.append("    claimRoles: ").append(this.toIndentedString(this.claimRoles)).append("\n");
        sb.append("    claimSessionId: ").append(this.toIndentedString(this.claimSessionId)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    discoveryUrl: ").append(this.toIndentedString(this.discoveryUrl)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString((Object)this.flow)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    logout: ").append(this.toIndentedString(this.logout)).append("\n");
        sb.append("    maxTimeSkew: ").append(this.toIndentedString(this.maxTimeSkew)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    roleNameAdmin: ").append(this.toIndentedString(this.roleNameAdmin)).append("\n");
        sb.append("    roleNameUser: ").append(this.toIndentedString(this.roleNameUser)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NameEnum {
        GENERIC("generic"),
        AZUREAD("azureAd"),
        AUTH0("auth0");

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FlowEnum {
        CLIENTCREDENTIALS("clientCredentials"),
        AUTHORIZATIONCODEWITHPKCE("authorizationCodeWithPkce");

        private String value;

        private FlowEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FlowEnum fromValue(String value) {
            for (FlowEnum b : FlowEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

