/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the access information for the server's truststore, which contains all third-party certificates that the server should trust. This applies to connections that the server establishes to external servers, such as HTTP SSL connections or LDAPS connections.")
@JsonPropertyOrder(value={"file", "password"})
@JsonTypeName(value="ServerConfig_TruststoreServer")
public class ServerConfigTruststoreServer {
    public static final String JSON_PROPERTY_FILE = "file";
    private String _file = "";
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "";

    public ServerConfigTruststoreServer _file(String _file) {
        this._file = _file;
        return this;
    }

    @Schema(name="The name (without path) of the JKS keystore file (in the \"keystore/\" folder) that is to serve as the server's truststore.")
    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFile() {
        return this._file;
    }

    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFile(String _file) {
        this._file = _file;
    }

    public ServerConfigTruststoreServer password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="The password required to access the truststore.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigTruststoreServer serverConfigTruststoreServer = (ServerConfigTruststoreServer)o;
        return Objects.equals(this._file, serverConfigTruststoreServer._file) && Objects.equals(this.password, serverConfigTruststoreServer.password);
    }

    public int hashCode() {
        return Objects.hash(this._file, this.password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigTruststoreServer {\n");
        sb.append("    _file: ").append(this.toIndentedString(this._file)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

