/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.auth.material;

import jakarta.xml.bind.DatatypeConverter;
import net.webpdf.wsclient.session.auth.material.AuthMaterial;
import net.webpdf.wsclient.session.auth.material.AuthMethod;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationMaterial
implements AuthMaterial {
    @NotNull
    private final String userName;
    private final char @NotNull [] password;

    public AuthenticationMaterial(@NotNull String user, char @NotNull [] password) {
        this.userName = user;
        this.password = password;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return new UsernamePasswordCredentials(this.userName, this.password);
    }

    @Override
    @Nullable
    public String getRawAuthHeader() {
        return AuthMethod.BASIC_AUTHORIZATION.getKey() + " " + this.getToken();
    }

    @Override
    @NotNull
    public String getToken() {
        return DatatypeConverter.printBase64Binary((byte[])(this.userName + ":" + new String(this.password)).getBytes());
    }
}

