/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.rest.administration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.openapi.AdminAggregationServerState;
import net.webpdf.wsclient.openapi.AdminApplicationCheck;
import net.webpdf.wsclient.openapi.AdminApplicationCheckMode;
import net.webpdf.wsclient.openapi.AdminApplicationConfiguration;
import net.webpdf.wsclient.openapi.AdminConfigurationMode;
import net.webpdf.wsclient.openapi.AdminConfigurationResult;
import net.webpdf.wsclient.openapi.AdminConfigurationType;
import net.webpdf.wsclient.openapi.AdminConnectorKeyStore;
import net.webpdf.wsclient.openapi.AdminDataSourceServerState;
import net.webpdf.wsclient.openapi.AdminExecutableApplicationCheck;
import net.webpdf.wsclient.openapi.AdminExecutableName;
import net.webpdf.wsclient.openapi.AdminFileDataStore;
import net.webpdf.wsclient.openapi.AdminFileGroupDataStore;
import net.webpdf.wsclient.openapi.AdminGlobalKeyStore;
import net.webpdf.wsclient.openapi.AdminLogCheck;
import net.webpdf.wsclient.openapi.AdminLogConfiguration;
import net.webpdf.wsclient.openapi.AdminLogFileConfiguration;
import net.webpdf.wsclient.openapi.AdminServerCheck;
import net.webpdf.wsclient.openapi.AdminServerConfiguration;
import net.webpdf.wsclient.openapi.AdminServerStatus;
import net.webpdf.wsclient.openapi.AdminStatistic;
import net.webpdf.wsclient.openapi.AdminSupportEntryGroup;
import net.webpdf.wsclient.openapi.AdminTrustStoreKeyStore;
import net.webpdf.wsclient.openapi.AdminUserCheck;
import net.webpdf.wsclient.openapi.AdminUserConfiguration;
import net.webpdf.wsclient.openapi.ApplicationConfigApplication;
import net.webpdf.wsclient.openapi.AuthUserCredentials;
import net.webpdf.wsclient.openapi.ServerConfigServer;
import net.webpdf.wsclient.openapi.SessionTable;
import net.webpdf.wsclient.openapi.UserConfigUsers;
import net.webpdf.wsclient.openapi.Webservice;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.connection.http.HttpMethod;
import net.webpdf.wsclient.session.connection.http.HttpRestRequest;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.session.rest.administration.AdministrationManager;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractAdministrationManager<T_REST_DOCUMENT extends RestDocument>
implements AdministrationManager<T_REST_DOCUMENT> {
    @NotNull
    private final RestSession<T_REST_DOCUMENT> session;
    @Nullable
    private ApplicationConfigApplication applicationConfiguration;
    @Nullable
    private ServerConfigServer serverConfiguration;
    @Nullable
    private UserConfigUsers userConfiguration;
    @Nullable
    private AdminLogFileConfiguration logConfiguration;
    @Nullable
    private AdminGlobalKeyStore globalKeyStore;
    @Nullable
    private Map<String, AdminConnectorKeyStore> connectorKeyStore;
    @Nullable
    private AdminTrustStoreKeyStore trustStoreKeyStore;

    AbstractAdministrationManager(@NotNull RestSession<T_REST_DOCUMENT> session) {
        this.session = session;
    }

    @Override
    @NotNull
    public RestSession<T_REST_DOCUMENT> getSession() {
        return this.session;
    }

    protected void validateUser() throws ResultException {
        AuthUserCredentials user = this.session.getUser();
        if (user == null || !user.getIsAdmin().booleanValue()) {
            throw new ClientResultException(Error.ADMIN_PERMISSION_ERROR);
        }
    }

    @Override
    @NotNull
    public Integer fetchLogLength(@Nullable Date date) throws ResultException {
        Integer n;
        block10: {
            this.validateUser();
            ArrayList<NameValuePair> searchParams = new ArrayList<NameValuePair>();
            if (date != null) {
                searchParams.add((NameValuePair)new BasicNameValuePair("date", DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd")));
            }
            ClassicHttpResponse response = HttpRestRequest.createRequest(this.session).setAcceptHeader(DataFormat.ANY.getMimeType()).buildRequest(HttpMethod.HEAD, this.session.getURI("admin/server/log", searchParams)).executeRequest();
            try {
                int contentLength = 0;
                Header contentLengthHeader = response.getHeader("Content-Length".toLowerCase());
                if (contentLengthHeader != null) {
                    contentLength = Integer.parseInt(contentLengthHeader.getValue());
                }
                n = contentLength;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ProtocolException ex) {
                    throw new ClientResultException(Error.HTTP_IO_ERROR, (Exception)ex);
                }
            }
            response.close();
        }
        return n;
    }

    @Override
    @NotNull
    public Integer fetchLogLength() throws ResultException {
        return this.fetchLogLength(null);
    }

    @Override
    @NotNull
    public String fetchLog(@NotNull String range, @Nullable Date date) throws ResultException {
        String logContent;
        this.validateUser();
        ArrayList<NameValuePair> searchParams = new ArrayList<NameValuePair>();
        if (date != null) {
            searchParams.add((NameValuePair)new BasicNameValuePair("date", DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd")));
        }
        if ((logContent = HttpRestRequest.createRequest(this.session).setAcceptHeader(DataFormat.PLAIN.getMimeType()).setAdditionalHeader("Range", "bytes=" + range).buildRequest(HttpMethod.GET, this.session.getURI("admin/server/log", searchParams)).executeRequest(String.class)) == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return logContent;
    }

    @Override
    @NotNull
    public String fetchLog(@NotNull String range) throws ResultException {
        return this.fetchLog(range, null);
    }

    @Override
    @NotNull
    public String fetchLog() throws ResultException {
        return this.fetchLog("0-");
    }

    @Override
    @NotNull
    public AdminServerStatus fetchServerStatus() throws ResultException {
        this.validateUser();
        AdminServerStatus status = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "admin/server/status").executeRequest(AdminServerStatus.class);
        if (status == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return status;
    }

    @Override
    public void buildSupportPackage(@NotNull OutputStream outputStream, @Nullable AdminSupportEntryGroup[] group, @Nullable Date start, @Nullable Date end) throws ResultException {
        this.validateUser();
        ArrayList<NameValuePair> searchParams = new ArrayList<NameValuePair>();
        if (group != null) {
            for (AdminSupportEntryGroup entryGroup : group) {
                if (entryGroup == null || entryGroup.getValue() == null) continue;
                searchParams.add((NameValuePair)new BasicNameValuePair("group", entryGroup.getValue()));
            }
        }
        if (start != null) {
            searchParams.add((NameValuePair)new BasicNameValuePair("start", DateFormatUtils.format((Date)start, (String)"yyyy-MM-dd")));
        }
        if (end != null) {
            searchParams.add((NameValuePair)new BasicNameValuePair("end", DateFormatUtils.format((Date)end, (String)"yyyy-MM-dd")));
        }
        HttpRestRequest.createRequest(this.session).setAcceptHeader(DataFormat.OCTET_STREAM.getMimeType()).buildRequest(HttpMethod.GET, this.session.getURI("admin/server/support", searchParams)).executeRequest(outputStream);
    }

    @Override
    public void buildSupportPackage(@NotNull OutputStream outputStream, @Nullable AdminSupportEntryGroup[] group) throws ResultException {
        this.buildSupportPackage(outputStream, group, null, null);
    }

    @Override
    public void buildSupportPackage(@NotNull OutputStream outputStream) throws ResultException {
        this.buildSupportPackage(outputStream, null, null, null);
    }

    @Override
    public void buildSupportPackage(@NotNull File target, @Nullable AdminSupportEntryGroup[] group, @Nullable Date start, @Nullable Date end) throws ResultException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            this.buildSupportPackage(outputStream, group, start, end);
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.HTTP_IO_ERROR, ex);
        }
    }

    @Override
    public void buildSupportPackage(@NotNull File target, @Nullable AdminSupportEntryGroup[] group) throws ResultException {
        this.buildSupportPackage(target, group, null, null);
    }

    @Override
    public void buildSupportPackage(@NotNull File target) throws ResultException {
        this.buildSupportPackage(target, null, null, null);
    }

    @Override
    public void restartServer() throws ResultException {
        this.validateUser();
        try {
            ClassicHttpResponse ignored = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "admin/server/restart").executeRequest();
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.HTTP_IO_ERROR, ex);
        }
    }

    @Override
    @NotNull
    public ApplicationConfigApplication fetchApplicationConfiguration() throws ResultException {
        this.validateUser();
        AdminApplicationConfiguration adminApplicationConfiguration = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "admin/configuration/application").executeRequest(AdminApplicationConfiguration.class);
        if (adminApplicationConfiguration == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        this.applicationConfiguration = adminApplicationConfiguration.getConfiguration();
        this.globalKeyStore = adminApplicationConfiguration.getGlobalKeyStore();
        return this.applicationConfiguration;
    }

    @Override
    @NotNull
    public ApplicationConfigApplication getApplicationConfiguration() throws ResultException {
        this.validateUser();
        return this.applicationConfiguration == null ? this.fetchApplicationConfiguration() : this.applicationConfiguration;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateApplicationConfiguration(@NotNull ApplicationConfigApplication configuration, @NotNull List<AdminApplicationCheck> checks) throws ResultException {
        this.validateUser();
        AdminApplicationConfiguration applicationConfiguration = new AdminApplicationConfiguration();
        applicationConfiguration.setConfiguration(configuration);
        applicationConfiguration.setConfigurationChecks(checks);
        applicationConfiguration.setConfigurationMode(AdminConfigurationMode.WRITE);
        applicationConfiguration.setConfigurationType(AdminConfigurationType.APPLICATION);
        applicationConfiguration.setGlobalKeyStore(this.getGlobalKeyStore());
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(applicationConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        if (configurationResult.getError() != null && configurationResult.getError().getCode() != null && configurationResult.getError().getCode() == 0) {
            this.applicationConfiguration = configuration;
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateApplicationConfiguration(@NotNull ApplicationConfigApplication configuration) throws ResultException {
        return this.updateApplicationConfiguration(configuration, new ArrayList<AdminApplicationCheck>());
    }

    @Override
    @NotNull
    public AdminConfigurationResult validateApplicationConfiguration(@NotNull ApplicationConfigApplication configuration, @NotNull List<AdminApplicationCheck> checks) throws ResultException {
        this.validateUser();
        AdminApplicationConfiguration applicationConfiguration = new AdminApplicationConfiguration();
        applicationConfiguration.setConfiguration(configuration);
        applicationConfiguration.setConfigurationChecks(checks);
        applicationConfiguration.setConfigurationMode(AdminConfigurationMode.VALIDATE);
        applicationConfiguration.setConfigurationType(AdminConfigurationType.APPLICATION);
        applicationConfiguration.setGlobalKeyStore(this.getGlobalKeyStore());
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(applicationConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public ServerConfigServer fetchServerConfiguration() throws ResultException {
        this.validateUser();
        AdminServerConfiguration adminServerConfiguration = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "admin/configuration/server").executeRequest(AdminServerConfiguration.class);
        if (adminServerConfiguration == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        this.serverConfiguration = adminServerConfiguration.getConfiguration();
        this.connectorKeyStore = adminServerConfiguration.getConnectorKeyStore();
        this.trustStoreKeyStore = adminServerConfiguration.getTrustStoreKeyStore();
        return this.serverConfiguration;
    }

    @Override
    @NotNull
    public ServerConfigServer getServerConfiguration() throws ResultException {
        this.validateUser();
        return this.serverConfiguration == null ? this.fetchServerConfiguration() : this.serverConfiguration;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateServerConfiguration(@NotNull ServerConfigServer configuration, @NotNull List<AdminServerCheck> checks) throws ResultException {
        this.validateUser();
        AdminServerConfiguration serverConfiguration = new AdminServerConfiguration();
        serverConfiguration.setConfiguration(configuration);
        serverConfiguration.setConfigurationChecks(checks);
        serverConfiguration.setConfigurationMode(AdminConfigurationMode.WRITE);
        serverConfiguration.setConfigurationType(AdminConfigurationType.SERVER);
        serverConfiguration.setTrustStoreKeyStore(this.getTrustStoreKeyStore());
        serverConfiguration.setConnectorKeyStore(this.getConnectorKeyStore());
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(serverConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        if (configurationResult.getError() != null && configurationResult.getError().getCode() != null && configurationResult.getError().getCode() == 0) {
            this.serverConfiguration = configuration;
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateServerConfiguration(@NotNull ServerConfigServer configuration) throws ResultException {
        return this.updateServerConfiguration(configuration, new ArrayList<AdminServerCheck>());
    }

    @Override
    @NotNull
    public AdminConfigurationResult validateServerConfiguration(@NotNull ServerConfigServer configuration, @NotNull List<AdminServerCheck> checks) throws ResultException {
        this.validateUser();
        AdminServerConfiguration serverConfiguration = new AdminServerConfiguration();
        serverConfiguration.setConfiguration(configuration);
        serverConfiguration.setConfigurationChecks(checks);
        serverConfiguration.setConfigurationMode(AdminConfigurationMode.VALIDATE);
        serverConfiguration.setConfigurationType(AdminConfigurationType.SERVER);
        serverConfiguration.setTrustStoreKeyStore(this.getTrustStoreKeyStore());
        serverConfiguration.setConnectorKeyStore(this.getConnectorKeyStore());
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(serverConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public UserConfigUsers fetchUserConfiguration() throws ResultException {
        this.validateUser();
        AdminUserConfiguration adminUserConfiguration = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "admin/configuration/user").executeRequest(AdminUserConfiguration.class);
        if (adminUserConfiguration == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        this.userConfiguration = adminUserConfiguration.getConfiguration();
        return this.userConfiguration;
    }

    @Override
    @NotNull
    public UserConfigUsers getUserConfiguration() throws ResultException {
        this.validateUser();
        return this.userConfiguration == null ? this.fetchUserConfiguration() : this.userConfiguration;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateUserConfiguration(@NotNull UserConfigUsers configuration, @NotNull List<AdminUserCheck> checks) throws ResultException {
        this.validateUser();
        AdminUserConfiguration userConfiguration = new AdminUserConfiguration();
        userConfiguration.setConfiguration(configuration);
        userConfiguration.setConfigurationChecks(checks);
        userConfiguration.setConfigurationMode(AdminConfigurationMode.WRITE);
        userConfiguration.setConfigurationType(AdminConfigurationType.USER);
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(userConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        if (configurationResult.getError() != null && configurationResult.getError().getCode() != null && configurationResult.getError().getCode() == 0) {
            this.userConfiguration = configuration;
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateUserConfiguration(@NotNull UserConfigUsers configuration) throws ResultException {
        return this.updateUserConfiguration(configuration, new ArrayList<AdminUserCheck>());
    }

    @Override
    @NotNull
    public AdminConfigurationResult validateUserConfiguration(@NotNull UserConfigUsers configuration, @NotNull List<AdminUserCheck> checks) throws ResultException {
        this.validateUser();
        AdminUserConfiguration userConfiguration = new AdminUserConfiguration();
        userConfiguration.setConfiguration(configuration);
        userConfiguration.setConfigurationChecks(checks);
        userConfiguration.setConfigurationMode(AdminConfigurationMode.VALIDATE);
        userConfiguration.setConfigurationType(AdminConfigurationType.USER);
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(userConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public AdminLogFileConfiguration fetchLogConfiguration() throws ResultException {
        this.validateUser();
        AdminLogConfiguration adminLogConfiguration = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "admin/configuration/log").executeRequest(AdminLogConfiguration.class);
        if (adminLogConfiguration == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        this.logConfiguration = adminLogConfiguration.getConfiguration();
        return this.logConfiguration;
    }

    @Override
    @NotNull
    public AdminLogFileConfiguration getLogConfiguration() throws ResultException {
        this.validateUser();
        return this.logConfiguration == null ? this.fetchLogConfiguration() : this.logConfiguration;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateLogConfiguration(@NotNull AdminLogFileConfiguration configuration, @NotNull List<AdminLogCheck> checks) throws ResultException {
        this.validateUser();
        AdminLogConfiguration logConfiguration = new AdminLogConfiguration();
        logConfiguration.setConfiguration(configuration);
        logConfiguration.setConfigurationChecks(checks);
        logConfiguration.setConfigurationMode(AdminConfigurationMode.WRITE);
        logConfiguration.setConfigurationType(AdminConfigurationType.LOG);
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(logConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        if (configurationResult.getError() != null && configurationResult.getError().getCode() != null && configurationResult.getError().getCode() == 0) {
            this.logConfiguration = configuration;
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public AdminConfigurationResult updateLogConfiguration(@NotNull AdminLogFileConfiguration configuration) throws ResultException {
        return this.updateLogConfiguration(configuration, new ArrayList<AdminLogCheck>());
    }

    @Override
    @NotNull
    public AdminConfigurationResult validateLogConfiguration(@NotNull AdminLogFileConfiguration configuration, @NotNull List<AdminLogCheck> checks) throws ResultException {
        this.validateUser();
        AdminLogConfiguration logConfiguration = new AdminLogConfiguration();
        logConfiguration.setConfiguration(configuration);
        logConfiguration.setConfigurationChecks(checks);
        logConfiguration.setConfigurationMode(AdminConfigurationMode.VALIDATE);
        logConfiguration.setConfigurationType(AdminConfigurationType.LOG);
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(logConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return configurationResult;
    }

    @Override
    @NotNull
    public AdminGlobalKeyStore fetchGlobalKeyStore() throws ResultException {
        this.validateUser();
        this.fetchApplicationConfiguration();
        if (this.globalKeyStore == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return this.globalKeyStore;
    }

    @Override
    @NotNull
    public AdminGlobalKeyStore getGlobalKeyStore() throws ResultException {
        this.validateUser();
        return this.globalKeyStore == null ? this.fetchGlobalKeyStore() : this.globalKeyStore;
    }

    @Override
    public void setGlobalKeyStore(@NotNull AdminGlobalKeyStore keystore) {
        this.globalKeyStore = keystore;
    }

    @Override
    @NotNull
    public AdminTrustStoreKeyStore fetchTrustStoreKeyStore() throws ResultException {
        this.validateUser();
        this.fetchServerConfiguration();
        if (this.trustStoreKeyStore == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return this.trustStoreKeyStore;
    }

    @Override
    @NotNull
    public AdminTrustStoreKeyStore getTrustStoreKeyStore() throws ResultException {
        this.validateUser();
        return this.trustStoreKeyStore == null ? this.fetchTrustStoreKeyStore() : this.trustStoreKeyStore;
    }

    @Override
    public void setTrustStoreKeyStore(@NotNull AdminTrustStoreKeyStore keystore) {
        this.trustStoreKeyStore = keystore;
    }

    @Override
    @NotNull
    public Map<String, AdminConnectorKeyStore> fetchConnectorKeyStore() throws ResultException {
        this.validateUser();
        this.fetchServerConfiguration();
        if (this.connectorKeyStore == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return this.connectorKeyStore;
    }

    @Override
    @NotNull
    public Map<String, AdminConnectorKeyStore> getConnectorKeyStore() throws ResultException {
        this.validateUser();
        return this.connectorKeyStore == null ? this.fetchConnectorKeyStore() : this.connectorKeyStore;
    }

    @Override
    public void setConnectorKeyStore(@NotNull Map<String, AdminConnectorKeyStore> keystore) {
        this.connectorKeyStore = keystore;
    }

    @Override
    @NotNull
    public AdminConfigurationResult testExecutables(@NotNull ApplicationConfigApplication configuration, @NotNull List<AdminExecutableName> executables) throws ResultException {
        this.validateUser();
        AdminApplicationConfiguration applicationConfiguration = new AdminApplicationConfiguration();
        applicationConfiguration.setConfiguration(configuration);
        AdminExecutableApplicationCheck executableCheck = new AdminExecutableApplicationCheck();
        executableCheck.setCheckType(AdminApplicationCheckMode.EXECUTABLE);
        executableCheck.setExecutables(executables);
        ArrayList<AdminApplicationCheck> checks = new ArrayList<AdminApplicationCheck>();
        checks.add(executableCheck);
        applicationConfiguration.setConfigurationChecks(checks);
        applicationConfiguration.setConfigurationMode(AdminConfigurationMode.VALIDATE);
        applicationConfiguration.setConfigurationType(AdminConfigurationType.APPLICATION);
        applicationConfiguration.setGlobalKeyStore(this.getGlobalKeyStore());
        AdminConfigurationResult configurationResult = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/configuration/", this.prepareHttpEntity(applicationConfiguration)).executeRequest(AdminConfigurationResult.class);
        if (configurationResult == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return configurationResult;
    }

    @Override
    public AdminFileDataStore fetchDatastore(@NotNull AdminFileGroupDataStore group, @Nullable String filename) throws ResultException {
        AdminFileDataStore fileDataStore;
        this.validateUser();
        ArrayList<NameValuePair> searchParams = new ArrayList<NameValuePair>();
        if (filename != null) {
            searchParams.add((NameValuePair)new BasicNameValuePair("name", filename));
        }
        if ((fileDataStore = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, this.session.getURI("admin/datastore/" + group, searchParams), null).executeRequest(AdminFileDataStore.class)) == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return fileDataStore;
    }

    @Override
    public AdminFileDataStore fetchDatastore(@NotNull AdminFileGroupDataStore group) throws ResultException {
        return this.fetchDatastore(group, null);
    }

    @Override
    public void updateDatastore(@NotNull AdminFileDataStore fileDataStore) throws ResultException {
        this.validateUser();
        HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/datastore/", this.prepareHttpEntity(fileDataStore)).executeRequest(AdminFileDataStore.class);
    }

    @Override
    public void deleteDatastore(@NotNull AdminFileGroupDataStore group, @Nullable String filename) throws ResultException {
        this.validateUser();
        ArrayList<NameValuePair> searchParams = new ArrayList<NameValuePair>();
        if (filename != null) {
            searchParams.add((NameValuePair)new BasicNameValuePair("name", filename));
        }
        try {
            ClassicHttpResponse ignored = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.DELETE, this.session.getURI("admin/datastore/" + group, searchParams), null).executeRequest();
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.HTTP_IO_ERROR, ex);
        }
    }

    @Override
    public void deleteDatastore(@NotNull AdminFileGroupDataStore group) throws ResultException {
        this.deleteDatastore(group, null);
    }

    @Override
    @NotNull
    public AdminStatistic fetchServerStatistic(@NotNull AdminDataSourceServerState dataSource, @NotNull AdminAggregationServerState aggregation, @NotNull List<Webservice> webservices, @NotNull Date start, @NotNull Date end) throws ResultException {
        this.validateUser();
        ArrayList<NameValuePair> searchParams = new ArrayList<NameValuePair>();
        searchParams.add((NameValuePair)new BasicNameValuePair("start", DateFormatUtils.format((Date)start, (String)DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.getPattern())));
        searchParams.add((NameValuePair)new BasicNameValuePair("end", DateFormatUtils.format((Date)end, (String)DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.getPattern())));
        for (Webservice webservice : webservices) {
            searchParams.add((NameValuePair)new BasicNameValuePair("webservice", webservice.getValue()));
        }
        AdminStatistic statistic = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, this.session.getURI("admin/statistic/" + dataSource.getValue() + "/" + aggregation.getValue(), searchParams)).executeRequest(AdminStatistic.class);
        if (statistic == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return statistic;
    }

    @Override
    @NotNull
    public SessionTable fetchSessionTable() throws ResultException {
        this.validateUser();
        SessionTable sessionTable = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "admin/session/table").executeRequest(SessionTable.class);
        if (sessionTable == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        return sessionTable;
    }

    @Override
    public void closeSession(@NotNull String sessionId) throws ResultException {
        this.validateUser();
        try {
            ClassicHttpResponse ignored = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "admin/session/" + sessionId + "/close").executeRequest();
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.HTTP_IO_ERROR, ex);
        }
    }

    @NotNull
    private <T> HttpEntity prepareHttpEntity(@NotNull T parameter) throws ResultException {
        try {
            return new StringEntity(SerializeHelper.toJSON(parameter), ContentType.create((String)DataFormat.JSON.getMimeType(), (Charset)StandardCharsets.UTF_8));
        }
        catch (UnsupportedCharsetException ex) {
            throw new ClientResultException(Error.XML_OR_JSON_CONVERSION_FAILURE, ex);
        }
    }
}

