/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.tools;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.tools.XMLValidationEventHandler;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class SerializeHelper {
    private static final String OPERATION_SCHEMA = "/schemas/operation/operation.xsd";

    private SerializeHelper() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String getResponseContent(@NotNull HttpEntity httpEntity) throws ResultException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(httpEntity.getContent());){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String tempToken;
                StringBuilder response = new StringBuilder();
                while ((tempToken = bufferedReader.readLine()) != null) {
                    response.append(tempToken);
                }
                string = response.toString();
            }
            return string;
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T fromXML(@Nullable HttpEntity httpEntity, @NotNull Class<T> type) throws ResultException {
        try {
            if (httpEntity == null) {
                throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT);
            }
            String response = EntityUtils.toString((HttpEntity)httpEntity);
            try (StringReader stringReader = new StringReader(response);){
                StreamSource streamSource = new StreamSource(stringReader);
                T t = SerializeHelper.fromXML(streamSource, type);
                return t;
            }
        }
        catch (IOException | ParseException ex) {
            throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT, (Exception)ex);
        }
    }

    @NotNull
    public static <T> T fromXML(@Nullable StreamSource streamSource, @NotNull Class<T> type) throws ResultException {
        if (streamSource == null) {
            throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT);
        }
        XMLValidationEventHandler xmlValidationEventHandler = new XMLValidationEventHandler();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{type});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = SerializeHelper.class.getResource(OPERATION_SCHEMA);
            Schema schema = schemaFactory.newSchema(url);
            if (schema != null) {
                unmarshaller.setSchema(schema);
                unmarshaller.setEventHandler((ValidationEventHandler)xmlValidationEventHandler);
            }
            JAXBElement jaxbElement = unmarshaller.unmarshal((Source)streamSource, type);
            return type.cast(jaxbElement.getValue());
        }
        catch (JAXBException | SAXException ex) {
            throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT, (Exception)ex).appendMessage(xmlValidationEventHandler.getMessages());
        }
    }

    @NotNull
    public static <T> T fromJSON(@Nullable HttpEntity httpEntity, @NotNull Class<T> type) throws ResultException {
        if (httpEntity == null) {
            throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT);
        }
        String response = SerializeHelper.getResponseContent(httpEntity);
        try (StringReader stringReader = new StringReader(response);){
            StreamSource streamSource = new StreamSource(stringReader);
            T t = SerializeHelper.fromJSON(streamSource, type);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T fromJSON(@Nullable StreamSource streamSource, @NotNull Class<T> type) throws ResultException {
        if (streamSource == null) {
            throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JakartaXmlBindAnnotationModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try (Reader reader = streamSource.getReader();){
            Object object = objectMapper.readValue(reader, type);
            return (T)object;
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.INVALID_HTTP_MESSAGE_CONTENT, ex);
        }
    }

    @NotNull
    public static String toJSON(@Nullable Object object) throws ResultException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JakartaXmlBindAnnotationModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw new ClientResultException(Error.XML_OR_JSON_CONVERSION_FAILURE, (Exception)((Object)ex));
        }
    }

    @NotNull
    public static String toXML(@Nullable Object object, @NotNull Class<?> type) throws ResultException {
        if (object == null) {
            throw new ClientResultException(Error.XML_OR_JSON_CONVERSION_FAILURE);
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter stringWriter = new StringWriter();
            jaxbMarshaller.marshal(object, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException ex) {
            throw new ClientResultException(Error.XML_OR_JSON_CONVERSION_FAILURE, (Exception)((Object)ex));
        }
    }
}

