/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.Flow;
import cascading.flow.FlowException;
import cascading.flow.FlowListener;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextLine;
import cascading.tap.MultiSourceTap;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.PartitionTap;
import cascading.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;

public class FailOnMissingSuccessFlowListener
implements FlowListener {
    public void onStarting(Flow flow) {
        Map sources = flow.getSources();
        for (Map.Entry entry : sources.entrySet()) {
            String key = (String)entry.getKey();
            Tap value = (Tap)entry.getValue();
            Set taps = Util.createIdentitySet();
            this.accumulate(taps, value);
            for (Hfs tap : taps) {
                if (this.testExists(flow, tap)) continue;
                throw new FlowException("cannot start flow: " + flow.getName() + ", _SUCCESS file missing in tap: '" + key + "', at: " + value.getIdentifier());
            }
        }
    }

    public boolean testExists(Flow flow, Hfs tap) {
        try {
            if (!tap.isDirectory(flow.getFlowProcess())) {
                return true;
            }
            return new Hfs((Scheme)new TextLine(), new Path(tap.getPath(), "_SUCCESS").toString()).resourceExists(flow.getFlowProcess());
        }
        catch (IOException exception) {
            throw new FlowException((Throwable)exception);
        }
    }

    public void accumulate(Set<Hfs> taps, Tap value) {
        if (value == null) {
            return;
        }
        if (value instanceof Hfs) {
            taps.add((Hfs)value);
        } else if (value instanceof PartitionTap) {
            taps.add((Hfs)((PartitionTap)value).getParent());
        } else if (value instanceof MultiSourceTap) {
            this.iterate(taps, (MultiSourceTap)value);
        } else {
            throw new IllegalArgumentException("unsupprted Tap type: " + value.getClass().getName());
        }
    }

    public void iterate(Set<Hfs> taps, MultiSourceTap value) {
        Iterator childTaps = value.getChildTaps();
        while (childTaps.hasNext()) {
            this.accumulate(taps, (Tap)childTaps.next());
        }
    }

    public void onStopping(Flow flow) {
    }

    public void onCompleted(Flow flow) {
    }

    public boolean onThrowable(Flow flow, Throwable throwable) {
        return false;
    }
}

