/*
 * Decompiled with CFR 0.152.
 */
package riffle.process.scheduler;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import riffle.process.DependencyIncoming;
import riffle.process.DependencyOutgoing;
import riffle.process.Process;
import riffle.process.ProcessChildren;
import riffle.process.ProcessCleanup;
import riffle.process.ProcessComplete;
import riffle.process.ProcessConfiguration;
import riffle.process.ProcessCounters;
import riffle.process.ProcessPrepare;
import riffle.process.ProcessStart;
import riffle.process.ProcessStop;
import riffle.process.scheduler.ProcessException;

public class ProcessWrapper
implements Serializable {
    Object process;

    public ProcessWrapper(Object process) {
        if (process == null) {
            throw new IllegalArgumentException("process argument may not be null");
        }
        this.process = process;
        this.verifyObjectIsProcess(process);
    }

    private void verifyObjectIsProcess(Object process) {
        Process annotation = process.getClass().getAnnotation(Process.class);
        if (annotation == null) {
            throw new IllegalArgumentException("given process instance must declare the Process annotation");
        }
        this.findMethodWith(DependencyOutgoing.class, false);
        this.findMethodWith(DependencyIncoming.class, false);
        this.findMethodWith(ProcessComplete.class, false);
        this.findMethodWith(ProcessStop.class, false);
        this.findMethodWith(ProcessConfiguration.class, true);
    }

    public Object getDependencyOutgoing() throws ProcessException {
        return this.findInvoke(DependencyOutgoing.class, false);
    }

    public Object getDependencyIncoming() throws ProcessException {
        return this.findInvoke(DependencyIncoming.class, false);
    }

    public Object getConfiguration() throws ProcessException {
        return this.findInvoke(ProcessConfiguration.class, true);
    }

    public boolean hasPrepare() {
        return this.findMethodWith(ProcessPrepare.class, true) != null;
    }

    public void prepare() throws ProcessException {
        this.findInvoke(ProcessPrepare.class, true);
    }

    public boolean hasCleanup() {
        return this.findMethodWith(ProcessCleanup.class, true) != null;
    }

    public void cleanup() throws ProcessException {
        this.findInvoke(ProcessCleanup.class, true);
    }

    public boolean hasStart() {
        return this.findMethodWith(ProcessStart.class, true) != null;
    }

    public void start() throws ProcessException {
        this.findInvoke(ProcessStart.class, true);
    }

    public void complete() throws ProcessException {
        this.findInvoke(ProcessComplete.class, false);
    }

    public void stop() throws ProcessException {
        this.findInvoke(ProcessStop.class, false);
    }

    public boolean hasCounters() throws ProcessException {
        return this.findMethodWith(ProcessCounters.class, true) != null;
    }

    public Map<String, Map<String, Long>> getCounters() throws ProcessException {
        Object counters = this.findInvoke(ProcessCounters.class, true);
        if (counters == null) {
            return null;
        }
        return (Map)counters;
    }

    public boolean hasChildren() throws ProcessException {
        return this.findMethodWith(ProcessChildren.class, true) != null;
    }

    public List<Object> getChildren() throws ProcessException {
        Object children = this.findInvoke(ProcessChildren.class, true);
        if (children == null) {
            return null;
        }
        return (List)children;
    }

    private Object findInvoke(Class<? extends Annotation> type, boolean isOptional) throws ProcessException {
        Method method = null;
        try {
            method = this.findMethodWith(type, isOptional);
            if (method == null) {
                return null;
            }
            return this.invokeMethod(method);
        }
        catch (InvocationTargetException exception) {
            throw new ProcessException(type, method, exception);
        }
    }

    private Object invokeMethod(Method method) throws InvocationTargetException {
        try {
            method.setAccessible(true);
            return method.invoke(this.process, new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("unable to invoke method: " + method.getName(), exception);
        }
        catch (InvocationTargetException exception) {
            if (exception.getCause() instanceof Error) {
                throw (Error)exception.getCause();
            }
            if (exception.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exception.getCause();
            }
            throw exception;
        }
    }

    private Method findMethodWith(Class<? extends Annotation> type, boolean isOptional) {
        Method[] methods;
        for (Method method : methods = this.process.getClass().getMethods()) {
            if (method.getAnnotation(type) == null) continue;
            int modifiers = method.getModifiers();
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalStateException("given process method: " + method.getName() + " must not be abstract");
            }
            if (Modifier.isInterface(modifiers)) {
                throw new IllegalStateException("given process method: " + method.getName() + " must be implemented");
            }
            if (!Modifier.isPublic(modifiers)) {
                throw new IllegalStateException("given process method: " + method.getName() + " must be public");
            }
            return method;
        }
        if (!isOptional) {
            throw new IllegalStateException("no method found declaring annotation: " + type.getName());
        }
        return null;
    }

    public String toString() {
        try {
            return this.getDependencyIncoming() + "->" + this.getDependencyOutgoing() + ":" + this.process.toString();
        }
        catch (ProcessException exception) {
            throw new IllegalStateException("unable to get source or sink", exception.getCause());
        }
    }
}

