/*
 * Decompiled with CFR 0.152.
 */
package xapi.util;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import xapi.util.X_Runtime;

public final class X_Util {
    private X_Util() {
    }

    public static boolean equal(Object one, Object two) {
        return one == two || one != null && one.equals(two);
    }

    public static <T> T firstNotNull(T first, T second) {
        return first == null ? second : first;
    }

    public static <T> T firstNotNull(T first, T second, T third) {
        return first == null ? (second == null ? third : second) : first;
    }

    public static <T> T firstNotNull(T first, T ... rest) {
        if (first == null) {
            for (T t : rest) {
                if (t == null) continue;
                return t;
            }
        }
        return first;
    }

    public static RuntimeException rethrow(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        while (e instanceof InvocationTargetException || e instanceof ExecutionException) {
            if (e.getCause() != null) {
                e = e.getCause();
                continue;
            }
            if (e != e.getCause()) continue;
        }
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw new RuntimeException(e);
    }

    public static int zeroSafeInt(Integer i) {
        return i == null ? 0 : i;
    }

    public static double zeroSafeDouble(Number i) {
        return i == null ? 0.0 : i.doubleValue();
    }

    public static Throwable unwrap(Throwable e) {
        if (X_Runtime.isDebug()) {
            e.printStackTrace();
        }
        while (e.getClass().equals(RuntimeException.class) || e.getClass().equals(ExecutionException.class)) {
            if (e.getCause() == null) {
                return e;
            }
            e = e.getCause();
        }
        return e;
    }
}

