/*
 * Decompiled with CFR 0.152.
 */
package xapi.adapter.log.gwt;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.log.CompositeTreeLogger;
import xapi.collect.api.Fifo;
import xapi.log.api.LogLevel;
import xapi.log.api.LogService;
import xapi.log.impl.JreLog;

public class GwtLogAdapter
extends CompositeTreeLogger {
    private final LogService service;
    private boolean logToChildren;

    public GwtLogAdapter(LogService service, TreeLogger ... children) {
        super(children);
        this.service = service == null ? new JreLog() : service;
    }

    public boolean isLoggable(TreeLogger.Type type) {
        switch (type) {
            case ALL: 
            case TRACE: {
                return this.service.shouldLog(LogLevel.ALL);
            }
            case DEBUG: {
                return this.service.shouldLog(LogLevel.DEBUG);
            }
            case ERROR: {
                return this.service.shouldLog(LogLevel.ERROR);
            }
            case INFO: {
                return this.service.shouldLog(LogLevel.INFO);
            }
            case SPAM: {
                return this.service.shouldLog(LogLevel.TRACE);
            }
            case WARN: {
                return this.service.shouldLog(LogLevel.WARN);
            }
        }
        return this.isLogToChildren() && super.isLoggable(type);
    }

    public void log(TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        Fifo<Object> fifo = this.service.newFifo();
        LogLevel level = GwtLogAdapter.toLevel(type);
        fifo.give((Object)msg);
        if (caught != null) {
            fifo.give(this.service.unwrap(level, caught));
        }
        if (helpInfo != null) {
            fifo.give((Object)helpInfo.getPrefix());
            if (helpInfo.getURL() != null) {
                fifo.give((Object)"\n");
                if (helpInfo.getAnchorText() != null) {
                    fifo.give((Object)helpInfo.getAnchorText());
                }
                fifo.give((Object)"Help URL").give((Object)helpInfo.getURL().toExternalForm());
            }
        }
        this.service.doLog(level, fifo);
        if (this.isLogToChildren()) {
            super.log(type, msg, caught, helpInfo);
        }
    }

    public static LogLevel toLevel(TreeLogger.Type type) {
        switch (type) {
            case ALL: 
            case SPAM: {
                return LogLevel.ALL;
            }
            case TRACE: {
                return LogLevel.TRACE;
            }
            case DEBUG: {
                return LogLevel.DEBUG;
            }
            case ERROR: {
                return LogLevel.ERROR;
            }
            case INFO: {
                return LogLevel.INFO;
            }
            case WARN: {
                return LogLevel.WARN;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean isLogToChildren() {
        return this.logToChildren;
    }

    public void setLogToChildren(boolean logToChildren) {
        this.logToChildren = logToChildren;
    }
}

