/*
 * Decompiled with CFR 0.152.
 */
package xapi.args;

import xapi.args.ArgHandler;
import xapi.args.OptionLogLevel;
import xapi.log.api.LogLevel;

public class ArgHandlerLogLevel
extends ArgHandler {
    private static final String OPTIONS_STRING = ArgHandlerLogLevel.computeOptionsString();
    private final OptionLogLevel options;

    private static String computeOptionsString() {
        StringBuffer sb = new StringBuffer();
        LogLevel[] values = LogLevel.values();
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (i + 1 == c) {
                sb.append("or ");
            }
            sb.append(values[i].name());
        }
        return sb.toString();
    }

    public ArgHandlerLogLevel(OptionLogLevel options) {
        this.options = options;
    }

    public String[] getDefaultArgs() {
        return new String[]{this.getTag(), this.getDefaultLogLevel().name()};
    }

    public String getPurpose() {
        return "The level of logging detail: " + OPTIONS_STRING;
    }

    public String getTag() {
        return "-logLevel";
    }

    public String[] getTagArgs() {
        return new String[]{"level"};
    }

    public int handle(String[] args, int startIndex) {
        if (startIndex + 1 < args.length) {
            try {
                LogLevel level = LogLevel.valueOf(args[startIndex + 1]);
                this.options.setLogLevel(level);
                return 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        System.err.println(this.getTag() + " should be followed by one of");
        System.err.println("  " + OPTIONS_STRING);
        return -1;
    }

    protected LogLevel getDefaultLogLevel() {
        return LogLevel.INFO;
    }
}

