/*
 * Decompiled with CFR 0.152.
 */
package xapi.log.impl;

import java.util.Iterator;
import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;
import xapi.log.api.LogLevel;
import xapi.log.api.LogService;

public abstract class AbstractLog
implements LogService {
    protected LogLevel logLevel = LogLevel.INFO;

    @Override
    public boolean shouldLog(LogLevel logLevel) {
        return this.logLevel.ordinal() <= logLevel.ordinal();
    }

    @Override
    public void log(LogLevel level, Object o) {
        if (this.shouldLog(level)) {
            Fifo<Object> arr = this.newFifo();
            arr.give(this.unwrap(level, o));
            this.doLog(level, arr);
        }
    }

    @Override
    public Iterable<Object> shouldIterate(Object m) {
        return m instanceof Fifo ? ((Fifo)m).forEach() : (m instanceof Iterable ? (Iterable)m : null);
    }

    @Override
    public Fifo<Object> newFifo() {
        return new SimpleFifo();
    }

    @Override
    public Object unwrap(LogLevel level, Object m) {
        if (m instanceof Throwable) {
            StackTraceElement[] trace = ((Throwable)m).getStackTrace();
            String serialized = m + "\n";
            if (trace != null) {
                for (StackTraceElement el : trace) {
                    serialized = serialized + String.valueOf(el) + "\n";
                }
            }
            return serialized;
        }
        if (m != null && m.getClass().isArray()) {
            return new SimpleFifo((Object[])m).join(", ");
        }
        if (m instanceof Iterable) {
            Iterator iter = ((Iterable)m).iterator();
            SimpleFifo fifo = new SimpleFifo();
            while (iter.hasNext()) {
                fifo.give((Object)String.valueOf(iter.next()));
            }
            return "[" + fifo.join(", ") + "]";
        }
        if (m instanceof Fifo) {
            return "{" + ((Fifo)m).join(", ") + "}";
        }
        return m == null ? "null" : m;
    }

    protected void writeLog(LogLevel level, StringBuilder b, Object object) {
        b.append(this.unwrap(level, object));
        b.append("\t");
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }
}

