/*
 * Decompiled with CFR 0.152.
 */
package xapi.log.impl;

import xapi.annotation.inject.SingletonDefault;
import xapi.collect.api.Fifo;
import xapi.log.api.LogLevel;
import xapi.log.api.LogService;
import xapi.log.impl.AbstractLog;
import xapi.util.X_Runtime;

@SingletonDefault(implFor=LogService.class)
public class JreLog
extends AbstractLog {
    public JreLog() {
        this.logLevel = LogLevel.valueOf(System.getProperty("xapi.log.level", X_Runtime.isDebug() ? "ALL" : "INFO"));
    }

    @Override
    public void doLog(LogLevel level, Fifo<Object> array) {
        StringBuilder b = new StringBuilder();
        while (!array.isEmpty()) {
            this.writeLog(level, b, array.take());
        }
        (level == LogLevel.ERROR ? System.err : System.out).println(b.toString());
    }

    @Override
    public Object unwrap(LogLevel level, Object m) {
        if (m instanceof Class) {
            Class c = (Class)m;
            for (StackTraceElement trace : new Throwable().getStackTrace()) {
                if (!trace.getClassName().equals(c.getName())) continue;
                return " " + trace;
            }
            return c.getCanonicalName();
        }
        return super.unwrap(level, m);
    }
}

