/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.model;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import xapi.log.X_Log;

@SupportedAnnotationTypes(value={"xapi.annotation.model.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ModelAnnotationProcessor
extends AbstractProcessor {
    protected Filer filer;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ClassLoader parentCl = ModelAnnotationProcessor.class.getClassLoader();
        URL[] urls = ((URLClassLoader)parentCl).getURLs();
        URLClassLoader cl = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        HashSet<String> annotatedTypes = new HashSet<String>();
        HashSet<String> annotatedPackages = new HashSet<String>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                Element e = element.getEnclosingElement();
                if (e instanceof TypeElement) {
                    annotatedTypes.add(((TypeElement)e).getQualifiedName().toString());
                    continue;
                }
                if (e instanceof PackageElement) {
                    annotatedPackages.add(((PackageElement)e).getQualifiedName().toString());
                    continue;
                }
                X_Log.warn((Object[])new Object[]{"Ignored an enclosing element that was not a TypeElement or package element", e, e.getClass()});
            }
        }
        for (String string : annotatedPackages) {
            X_Log.info((Object[])new Object[]{"Model Package", string});
        }
        for (String string : annotatedTypes) {
            Class<?> cls = this.loadClass(string, cl);
            X_Log.info((Object[])new Object[]{"Loaded model: ", cls});
        }
        if (roundEnv.processingOver()) {
            // empty if block
        }
        return true;
    }

    private Class<?> loadClass(String s, ClassLoader cl) {
        try {
            return cl.loadClass(s);
        }
        catch (Throwable e) {
            int ind = s.lastIndexOf(46);
            String tryLoad = s;
            ArrayDeque<String> stack = new ArrayDeque<String>();
            while (ind != -1) {
                stack.add(tryLoad.substring(ind + 1));
                tryLoad = tryLoad.substring(0, ind);
                try {
                    Class<?> cls = cl.loadClass(tryLoad);
                    block5: while (stack.size() > 0) {
                        String next = (String)stack.pop();
                        for (Class<?> inner : cls.getClasses()) {
                            if (!inner.getSimpleName().equals(next)) continue;
                            cls = inner;
                            continue block5;
                        }
                        throw new RuntimeException(new ClassNotFoundException("Could not load class: " + s + "; ensure that it is public " + "and available on the classpath."));
                    }
                    return cls;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ind = tryLoad.lastIndexOf(46);
                }
            }
            throw new RuntimeException(new ClassNotFoundException(s));
        }
    }

    protected Iterable<String> getPlatforms(Element element) {
        return Arrays.asList("");
    }

    void dumpType(Element anno) {
        this.processingEnv.getElementUtils().printElements(new PrintWriter(System.out), anno);
    }
}

