/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.model;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import xapi.annotation.model.ClientToServer;
import xapi.annotation.model.FieldValidator;
import xapi.annotation.model.Key;
import xapi.annotation.model.PersistenceStrategy;
import xapi.annotation.model.Persistent;
import xapi.annotation.model.Serializable;
import xapi.annotation.model.SerializationStrategy;
import xapi.annotation.model.ServerToClient;
import xapi.collect.impl.SimpleFifo;
import xapi.log.X_Log;
import xapi.source.api.IsType;
import xapi.util.api.ValidatesValue;

public class ModelField
implements java.io.Serializable {
    private static final long serialVersionUID = -1697272589093249083L;
    private final String name;
    private String type;
    private ClientToServer clientToServer;
    private ServerToClient serverToClient;
    private Key key;
    private Persistent persistent;
    private Serializable serializable;
    private boolean listType;
    private boolean mapType;
    private boolean publicSetter;
    private boolean publicAdder;
    private boolean publicRemover;
    private boolean publicClear;
    private boolean c2sEnabled = true;
    private boolean s2cEnabled = true;
    private boolean c2sEncrypted = false;
    private boolean s2cEncrypted = false;
    private boolean obfuscated = false;
    private SerializationStrategy c2sSerializer = SerializationStrategy.ProtoStream;
    private SerializationStrategy s2cSerializer = SerializationStrategy.ProtoStream;
    private PersistenceStrategy persistenceStrategy;
    private final ArrayList<Class<? extends ValidatesValue<?>>> validators = new ArrayList();
    private final SimpleFifo<GetterMethod> getters;
    private final SimpleFifo<SetterMethod> setters;
    private final SimpleFifo<ActionMethod> actions;

    public ModelField(String name) {
        this.name = name;
        this.getters = new SimpleFifo();
        this.setters = new SimpleFifo();
        this.actions = new SimpleFifo();
    }

    public ClientToServer getClientToServer() {
        return this.clientToServer;
    }

    public ModelField setClientToServer(ClientToServer clientToServer) {
        this.clientToServer = clientToServer;
        if (clientToServer != null) {
            this.c2sEnabled = clientToServer.enabled();
            this.c2sEncrypted = clientToServer.enabled();
            this.c2sSerializer = clientToServer.serializer();
        }
        return this;
    }

    public Key getKey() {
        return this.key;
    }

    public ModelField setKey(Key key) {
        this.key = key;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ServerToClient getServerToClient() {
        return this.serverToClient;
    }

    public ModelField setServerToClient(ServerToClient serverToClient) {
        this.serverToClient = serverToClient;
        if (serverToClient != null) {
            this.s2cEnabled = serverToClient.enabled();
            this.s2cEncrypted = serverToClient.encrypted();
            this.s2cSerializer = serverToClient.serializer();
        }
        return this;
    }

    public Serializable getSerializable() {
        return this.serializable;
    }

    public ModelField setSerializable(Serializable serializable) {
        this.serializable = serializable;
        if (serializable != null) {
            this.obfuscated = serializable.obfuscated();
            this.setClientToServer(serializable.clientToServer());
            this.setServerToClient(serializable.serverToClient());
        }
        return this;
    }

    public Persistent getPersistent() {
        return this.persistent;
    }

    public ModelField setPersistent(Persistent persistent) {
        this.persistent = persistent;
        if (persistent != null) {
            this.persistenceStrategy = persistent.strategy();
        }
        return this;
    }

    public boolean equals(Object obj) {
        return obj == this ? true : (obj instanceof ModelField ? this.name.equals(((ModelField)obj).name) : false);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public GetterMethod addGetter(IsType returns, String propertyName, String methodName, Annotation[] annotations) {
        GetterMethod mthd = new GetterMethod();
        mthd.returnType = returns;
        mthd.fieldName = propertyName;
        mthd.methodName = methodName;
        this.getters.give((Object)mthd);
        this.addAnnotations(annotations);
        return mthd;
    }

    private void addAnnotations(Annotation[] annotations) {
        for (Annotation anno : annotations) {
            if (anno instanceof Serializable) {
                Serializable serializable = (Serializable)anno;
                this.obfuscated = serializable.obfuscated();
                ClientToServer c2s = serializable.clientToServer();
                this.c2sSerializer = c2s.serializer();
                this.c2sEnabled = c2s.enabled();
                this.c2sEncrypted = c2s.encrypted();
                ServerToClient s2c = serializable.serverToClient();
                this.s2cSerializer = s2c.serializer();
                this.s2cEnabled = s2c.enabled();
                this.s2cEncrypted = s2c.encrypted();
                continue;
            }
            if (anno instanceof Persistent) {
                Persistent persistent = (Persistent)anno;
                this.persistenceStrategy = persistent.strategy();
                continue;
            }
            if (anno instanceof FieldValidator) {
                FieldValidator validator = (FieldValidator)anno;
                for (Class validatesValue : validator.validators()) {
                    this.validators.add(validatesValue);
                }
                continue;
            }
            X_Log.trace((Object[])new Object[]{this.getClass(), "Unhandled annotation ", anno + " in ModelManifest.MethodData.addAnnotatons"});
        }
    }

    public SetterMethod addSetter(IsType returns, String propertyName, String methodName, Annotation[] annotations, IsType[] parameters) {
        SetterMethod mthd = new SetterMethod();
        mthd.returnType = returns;
        mthd.fieldName = propertyName;
        mthd.methodName = methodName;
        mthd.params = parameters;
        this.setters.give((Object)mthd);
        mthd.fluent = mthd.returnType.getQualifiedName().equals(this.type);
        this.addAnnotations(annotations);
        return mthd;
    }

    public void addAction(IsType returns, String propertyName, String methodName, Annotation[] annotations, IsType[] parameters) {
        ActionMethod mthd = new ActionMethod();
        mthd.returnType = returns;
        mthd.fieldName = propertyName;
        mthd.methodName = methodName;
        mthd.params = parameters;
        this.actions.give((Object)mthd);
        this.addAnnotations(annotations);
    }

    public Iterable<GetterMethod> getGetters() {
        return this.getters.forEach();
    }

    public Iterable<SetterMethod> getSetters() {
        return this.setters.forEach();
    }

    public Iterable<ActionMethod> getActions() {
        return this.actions.forEach();
    }

    public boolean isC2sEnabled() {
        return this.c2sEnabled;
    }

    public boolean isS2cEnabled() {
        return this.s2cEnabled;
    }

    public boolean isC2sEncrypted() {
        return this.c2sEncrypted;
    }

    public boolean isS2cEncrypted() {
        return this.s2cEncrypted;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public String toString() {
        return this.type + " " + this.name;
    }

    public SerializationStrategy getC2sSerializer() {
        return this.c2sSerializer;
    }

    public SerializationStrategy getS2cSerializer() {
        return this.s2cSerializer;
    }

    public PersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public Class<? extends ValidatesValue<?>>[] getValidators() {
        return this.validators.toArray(new Class[this.validators.size()]);
    }

    class ActionMethod
    implements java.io.Serializable {
        IsType returnType;
        String methodName;
        String fieldName;
        IsType[] params;

        ActionMethod() {
        }
    }

    class QueryMethod
    extends ModelMethod {
        private static final long serialVersionUID = -4769829367905793190L;
        IsType[] params;
        public boolean fluent;
        boolean fromArray;
        boolean fromCollection;
        boolean fromMap;
        boolean fromHasValues;
        boolean fromIterable;
        boolean firesEvents;

        QueryMethod() {
        }
    }

    class DeleterMethod
    extends ModelMethod {
        private static final long serialVersionUID = 7402005778480651359L;
        IsType[] params;
        public boolean fluent;
        boolean fromArray;
        boolean fromCollection;
        boolean fromMap;
        boolean fromHasValues;
        boolean fromIterable;
        boolean firesEvents;

        DeleterMethod() {
        }
    }

    class SetterMethod
    extends ModelMethod {
        private static final long serialVersionUID = -345008117582324787L;
        IsType[] params;
        public boolean fluent;
        boolean fromArray;
        boolean fromCollection;
        boolean fromMap;
        boolean fromHasValues;
        boolean fromIterable;
        boolean firesEvents;

        SetterMethod() {
        }
    }

    class GetterMethod
    extends ModelMethod {
        private static final long serialVersionUID = -7494752742665409918L;
        boolean toArray;
        boolean toCollection;
        boolean toMap;
        boolean toHasValues;
        boolean toIterable;

        GetterMethod() {
        }
    }

    class ModelMethod
    implements java.io.Serializable {
        private static final long serialVersionUID = -7865206427761038557L;
        String fieldName;
        IsType returnType;
        String methodName;

        ModelMethod() {
        }
    }
}

