/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.api;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import xapi.annotation.model.ClientToServer;
import xapi.annotation.model.DeleterFor;
import xapi.annotation.model.FieldValidator;
import xapi.annotation.model.GetterFor;
import xapi.annotation.model.IsModel;
import xapi.annotation.model.PersistenceStrategy;
import xapi.annotation.model.Persistent;
import xapi.annotation.model.Serializable;
import xapi.annotation.model.SerializationStrategy;
import xapi.annotation.model.ServerToClient;
import xapi.annotation.model.SetterFor;
import xapi.dev.source.CharBuffer;
import xapi.log.X_Log;
import xapi.model.X_Model;
import xapi.model.api.Model;
import xapi.model.api.ModelMethodType;
import xapi.model.api.PrimitiveSerializer;
import xapi.model.impl.ModelNameUtil;
import xapi.model.impl.ModelUtil;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;
import xapi.util.api.ValidatesValue;

public class ModelManifest {
    private final Map<String, MethodData> methodsByPropertyNames = new LinkedHashMap<String, MethodData>();
    private final Map<String, MethodData> methodsByMethodNames = new HashMap<String, MethodData>();
    private final Annotation[] defaultAnnotations;
    private final String type;
    private String[] properties;
    private final Class<? extends Model> modelType;

    public static String serialize(ModelManifest manifest) {
        return ModelManifest.serialize(new CharBuffer(), manifest, X_Model.getService().primitiveSerializer()).toString();
    }

    public static CharBuffer serialize(CharBuffer out, ModelManifest manifest, PrimitiveSerializer primitives) {
        if (out == null) {
            out = new CharBuffer();
        }
        out.append(primitives.serializeString(manifest.type));
        out.append(primitives.serializeClass(manifest.modelType));
        out.append(primitives.serializeInt(manifest.getPropertyNames().length));
        for (String property : manifest.properties) {
            out.append(primitives.serializeString(property));
        }
        for (String property : manifest.properties) {
            MethodData data = manifest.methodsByPropertyNames.get(property);
            MethodData.serializeData(out, data, primitives);
        }
        return out;
    }

    public static ModelManifest deserialize(String asString) {
        return ModelManifest.deserialize((CharIterator)new StringCharIterator(asString), X_Model.getService().primitiveSerializer());
    }

    public static ModelManifest deserialize(CharIterator chars, PrimitiveSerializer primitives) {
        MethodData data;
        String typeName = primitives.deserializeString(chars);
        Class modelType = primitives.deserializeClass(chars);
        ModelManifest manifest = new ModelManifest(typeName, modelType);
        int numProps = primitives.deserializeInt(chars);
        manifest.properties = new String[numProps];
        for (int i = 0; i < numProps; ++i) {
            manifest.properties[i] = primitives.deserializeString(chars);
        }
        for (String property : manifest.properties) {
            data = MethodData.deserializeData(chars, primitives);
            manifest.methodsByPropertyNames.put(property, data);
        }
        for (String property : manifest.properties) {
            data = manifest.methodsByPropertyNames.get(property);
            for (String methodName : data.methodNames.keySet()) {
                manifest.methodsByMethodNames.put(methodName, data);
            }
        }
        return manifest;
    }

    private ModelManifest(String typeName, Class<? extends Model> cls) {
        this.type = typeName;
        this.modelType = cls;
        this.defaultAnnotations = new Annotation[0];
    }

    public ModelManifest(Class<? extends Model> cls) {
        this.modelType = cls;
        IsModel isModel = cls.getAnnotation(IsModel.class);
        if (isModel == null) {
            String name = ModelUtil.guessModelType(cls.getSimpleName());
            if (name.length() == 0) {
                name = "model";
            }
            this.type = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            this.defaultAnnotations = new Annotation[0];
        } else {
            this.type = isModel.modelType();
            this.defaultAnnotations = new Annotation[]{isModel.persistence(), isModel.serializable()};
            if (isModel.propertyOrder().length > 0) {
                this.properties = isModel.propertyOrder();
            }
        }
    }

    public MethodData addProperty(String methodName, GetterFor getter, SetterFor setter, DeleterFor deleter) {
        MethodData data;
        if (this.methodsByMethodNames.containsKey(methodName)) {
            data = this.methodsByMethodNames.get(methodName);
            data.recordMethod(methodName, getter, setter, deleter);
        } else {
            data = new MethodData(methodName, getter, setter, deleter);
            if (this.methodsByPropertyNames.containsKey(data.name)) {
                data = this.methodsByPropertyNames.get(data.name);
                data.recordMethod(methodName, getter, setter, deleter);
            } else if (this.defaultAnnotations.length > 0) {
                data.addAnnotations(this.defaultAnnotations);
            }
            this.methodsByMethodNames.put(methodName, data);
        }
        this.methodsByPropertyNames.put(data.getName(), data);
        return data;
    }

    public SerializationStrategy getClientToServerSerializationStrategy(String name) {
        return this.getMethodData(name).c2sSerializer;
    }

    public SerializationStrategy getServerToClientSerializationStrategy(String name) {
        return this.getMethodData(name).s2cSerializer;
    }

    public boolean isClientToServerEnabled(String name) {
        return this.getMethodData(name).c2sEnabled;
    }

    public boolean isClientToServerEncrypted(String name) {
        return this.getMethodData(name).c2sEncrypted;
    }

    public boolean isServerToClientEnabled(String name) {
        return this.getMethodData(name).s2cEnabled;
    }

    public boolean isServerToClientEncrypted(String name) {
        return this.getMethodData(name).s2cEncrypted;
    }

    public boolean isSerializationObfuscated(String name) {
        return this.getMethodData(name).obfuscated;
    }

    public PersistenceStrategy getPersistenceStrategy(String name) {
        return this.getMethodData(name).persistenceStrategy;
    }

    public Class<? extends ValidatesValue<?>>[] getValidatorTypes(String name) {
        return this.getMethodData(name).validators.toArray(new Class[0]);
    }

    public MethodData getMethodData(String name) {
        MethodData data = this.methodsByPropertyNames.get(name);
        if (data == null && (data = this.methodsByMethodNames.get(name)) == null) {
            throw new UnsupportedOperationException("Cannot find MethodData for property " + name);
        }
        return data;
    }

    public ModelMethodType getMethodType(String name) {
        MethodData data = this.getMethodData(name);
        return data.getMethodType(name);
    }

    public boolean hasSeenMethod(String methodName) {
        return this.methodsByMethodNames.containsKey(methodName);
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends Model> getModelType() {
        return this.modelType;
    }

    public String[] getPropertyNames() {
        if (this.properties == null) {
            this.properties = this.methodsByPropertyNames.keySet().toArray(new String[this.methodsByPropertyNames.size()]);
        }
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelManifest) {
            ModelManifest other = (ModelManifest)obj;
            if (!other.type.equals(this.type)) {
                return false;
            }
            if (!Arrays.equals(other.getPropertyNames(), this.getPropertyNames())) {
                return false;
            }
            if (other.methodsByPropertyNames.size() != this.methodsByPropertyNames.size()) {
                return false;
            }
            if (other.methodsByMethodNames.size() != this.methodsByMethodNames.size()) {
                return false;
            }
            if (!other.methodsByMethodNames.keySet().containsAll(this.methodsByMethodNames.keySet())) {
                return false;
            }
            for (Map.Entry<String, MethodData> entry : this.methodsByPropertyNames.entrySet()) {
                MethodData data = other.methodsByPropertyNames.get(entry.getKey());
                if (data == null) {
                    return false;
                }
                if (data.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        hash ^= this.properties.length;
        for (String property : this.properties) {
            hash ^= property.hashCode();
        }
        return hash;
    }

    public boolean isIndexed(String propertyName) {
        return true;
    }

    public static class MethodData {
        private final String name;
        private SerializationStrategy c2sSerializer = SerializationStrategy.ProtoStream;
        private SerializationStrategy s2cSerializer = SerializationStrategy.ProtoStream;
        private boolean c2sEnabled = true;
        private boolean s2cEnabled = true;
        private boolean c2sEncrypted = false;
        private boolean s2cEncrypted = false;
        private boolean obfuscated;
        private PersistenceStrategy persistenceStrategy;
        private final ArrayList<Class<? extends ValidatesValue<?>>> validators;
        private Class<?> type;
        Map<String, ModelMethodType> methodNames = new HashMap<String, ModelMethodType>();

        public MethodData(String name) {
            this.name = name;
            this.validators = new ArrayList();
        }

        public MethodData(String name, GetterFor getter, SetterFor setter, DeleterFor deleter) {
            this.validators = new ArrayList();
            this.name = this.recordMethod(name, getter, setter, deleter);
        }

        public String getName() {
            return this.name;
        }

        public void addAnnotations(Annotation[] annos) {
            for (Annotation anno : annos) {
                if (anno instanceof Serializable) {
                    Serializable serializable = (Serializable)anno;
                    this.obfuscated = serializable.obfuscated();
                    ClientToServer c2s = serializable.clientToServer();
                    this.c2sSerializer = c2s.serializer();
                    this.c2sEnabled = c2s.enabled();
                    this.c2sEncrypted = c2s.encrypted();
                    ServerToClient s2c = serializable.serverToClient();
                    this.s2cSerializer = s2c.serializer();
                    this.s2cEnabled = s2c.enabled();
                    this.s2cEncrypted = s2c.encrypted();
                    continue;
                }
                if (anno instanceof Persistent) {
                    Persistent persistent = (Persistent)anno;
                    this.persistenceStrategy = persistent.strategy();
                    continue;
                }
                if (anno instanceof FieldValidator) {
                    FieldValidator validator = (FieldValidator)anno;
                    for (Class validatesValue : validator.validators()) {
                        this.validators.add(validatesValue);
                    }
                    continue;
                }
                X_Log.trace((Object[])new Object[]{this.getClass(), "Unhandled annotation ", anno + " in ModelManifest.MethodData.addAnnotatons"});
            }
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isGetter(String name) {
            return this.methodNames.get(name) == ModelMethodType.GET;
        }

        public String recordMethod(String methodName, GetterFor getter, SetterFor setter, DeleterFor deleter) {
            String name;
            ModelMethodType methodType = ModelMethodType.deduceMethodType(methodName, getter, setter, deleter);
            switch (methodType) {
                case GET: {
                    if (getter == null || getter.value().length() == 0) {
                        name = ModelNameUtil.stripGetter(methodName);
                        break;
                    }
                    name = getter.value();
                    break;
                }
                case SET: 
                case ADD: 
                case ADD_ALL: {
                    if (setter == null || setter.value().length() == 0) {
                        name = ModelNameUtil.stripSetter(methodName);
                        break;
                    }
                    name = setter.value();
                    break;
                }
                case REMOVE: 
                case CLEAR: {
                    if (deleter == null || deleter.value().length() == 0) {
                        name = ModelNameUtil.stripRemover(methodName);
                        break;
                    }
                    name = deleter.value();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Method " + methodName + " is not a valid model data accessor");
                }
            }
            this.methodNames.put(methodName, methodType);
            assert (this.name == null || this.name.equals(name)) : "Malformed property naming collision; Model of type " + this.type + " has a field " + this.name + "which has received a new property " + "with the name " + name;
            return name;
        }

        public ModelMethodType getMethodType(String methodName) {
            return this.methodNames.get(methodName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodData) {
                MethodData other = (MethodData)obj;
                if (!other.name.equals(this.name)) {
                    return false;
                }
                if (other.type != this.type) {
                    return false;
                }
                if (other.c2sEnabled != this.c2sEnabled) {
                    return false;
                }
                if (other.s2cEnabled != this.s2cEnabled) {
                    return false;
                }
                if (other.c2sEncrypted != this.c2sEncrypted) {
                    return false;
                }
                if (other.s2cEncrypted != this.s2cEncrypted) {
                    return false;
                }
                if (other.obfuscated != this.obfuscated) {
                    return false;
                }
                if (other.persistenceStrategy != this.persistenceStrategy) {
                    return false;
                }
                if (other.validators.size() != this.validators.size()) {
                    return false;
                }
                for (int i = 0; i < this.validators.size(); ++i) {
                    if (other.validators.get(i) == this.validators.get(i)) continue;
                    return false;
                }
                if (other.methodNames.size() != this.methodNames.size()) {
                    return false;
                }
                for (Map.Entry<String, ModelMethodType> entry : other.methodNames.entrySet()) {
                    ModelMethodType type = this.methodNames.get(entry.getKey());
                    if (type == entry.getValue()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.type.hashCode();
        }

        static CharBuffer serializeData(CharBuffer out, MethodData data, PrimitiveSerializer primitives) {
            out.append(primitives.serializeString(data.name));
            out.append(primitives.serializeClass(data.type));
            out.append(primitives.serializeBooleanArray(data.c2sEnabled, data.s2cEnabled, data.c2sEncrypted, data.s2cEncrypted, data.obfuscated));
            out.append(primitives.serializeInt(data.c2sSerializer.ordinal()));
            out.append(primitives.serializeInt(data.s2cSerializer.ordinal()));
            if (data.persistenceStrategy == null) {
                out.append(primitives.serializeInt(-1));
            } else {
                out.append(primitives.serializeInt(data.persistenceStrategy.ordinal()));
            }
            out.append(primitives.serializeInt(data.validators.size()));
            for (Class<? extends ValidatesValue<?>> clazz : data.validators) {
                out.append(primitives.serializeClass(clazz));
            }
            out.append(primitives.serializeInt(data.methodNames.size()));
            for (Map.Entry entry : data.methodNames.entrySet()) {
                out.append(primitives.serializeInt(((ModelMethodType)((Object)entry.getValue())).ordinal()));
                if (((ModelMethodType)((Object)entry.getValue())).isDefaultName((String)entry.getKey(), data.name)) {
                    out.append(primitives.serializeString(null));
                    continue;
                }
                out.append(primitives.serializeString((String)entry.getKey()));
            }
            return out;
        }

        static MethodData deserializeData(CharIterator chars, PrimitiveSerializer primitives) {
            String name = primitives.deserializeString(chars);
            MethodData data = new MethodData(name);
            data.type = primitives.deserializeClass(chars);
            boolean[] bools = primitives.deserializeBooleanArray(chars);
            data.c2sEnabled = bools[0];
            data.s2cEnabled = bools[1];
            data.c2sEncrypted = bools[2];
            data.s2cEncrypted = bools[3];
            data.obfuscated = bools[4];
            int ordinal = primitives.deserializeInt(chars);
            data.c2sSerializer = SerializationStrategy.values()[ordinal];
            ordinal = primitives.deserializeInt(chars);
            data.s2cSerializer = SerializationStrategy.values()[ordinal];
            ordinal = primitives.deserializeInt(chars);
            if (ordinal != -1) {
                data.persistenceStrategy = PersistenceStrategy.values()[ordinal];
            }
            int numValidators = primitives.deserializeInt(chars);
            while (numValidators-- > 0) {
                data.validators.add(primitives.deserializeClass(chars));
            }
            int numMethods = primitives.deserializeInt(chars);
            while (numMethods-- > 0) {
                ordinal = primitives.deserializeInt(chars);
                String methodName = primitives.deserializeString(chars);
                ModelMethodType methodType = ModelMethodType.values()[ordinal];
                if (methodName == null) {
                    methodName = methodType.getDefaultName(name);
                }
                data.methodNames.put(methodName, methodType);
            }
            return data;
        }
    }
}

