/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.api;

import xapi.annotation.model.DeleterFor;
import xapi.annotation.model.GetterFor;
import xapi.annotation.model.SetterFor;
import xapi.model.impl.ModelNameUtil;

public enum ModelMethodType {
    GET("get"),
    SET("set"),
    ADD("add"),
    ADD_ALL("addAll"),
    REMOVE("remove"),
    CLEAR("clear");

    private String prefix;

    private ModelMethodType(String prefix) {
        this.prefix = prefix;
    }

    public static String deducePropertyName(String name, GetterFor getter, SetterFor setter, DeleterFor deleter) {
        switch (ModelMethodType.deduceMethodType(name, getter, setter, deleter)) {
            case GET: {
                return getter == null || getter.value().isEmpty() ? ModelNameUtil.stripGetter(name) : getter.value();
            }
            case SET: 
            case ADD: 
            case ADD_ALL: {
                return setter == null || setter.value().isEmpty() ? ModelNameUtil.stripSetter(name) : setter.value();
            }
            case REMOVE: 
            case CLEAR: {
                return deleter == null || deleter.value().isEmpty() ? ModelNameUtil.stripRemover(name) : deleter.value();
            }
        }
        throw new UnsupportedOperationException("Method " + name + " is not a valid model method name");
    }

    public static ModelMethodType deduceMethodType(String name, GetterFor getter, SetterFor setter, DeleterFor deleter) {
        String prefix;
        if (getter != null) {
            return GET;
        }
        if (setter != null) {
            return SET;
        }
        if (deleter != null) {
            return REMOVE;
        }
        switch (prefix = name.replaceFirst("[A-Z].*", "")) {
            case "get": 
            case "is": 
            case "has": {
                return GET;
            }
            case "set": {
                return SET;
            }
            case "add": {
                return name.startsWith(prefix + "All") ? ADD_ALL : ADD;
            }
            case "rem": 
            case "remove": {
                return name.startsWith(prefix + "All") ? CLEAR : REMOVE;
            }
            case "clear": {
                return CLEAR;
            }
        }
        throw new UnsupportedOperationException("Method " + name + " is not a valid model method name");
    }

    public boolean isDefaultName(String methodName, String propertyName) {
        return methodName.equals(this.getDefaultName(propertyName));
    }

    public String getDefaultName(String propertyName) {
        return this.prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

