/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import xapi.annotation.inject.InstanceDefault;
import xapi.collect.X_Collect;
import xapi.collect.api.StringTo;
import xapi.log.X_Log;
import xapi.model.X_Model;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.model.api.NestedModel;
import xapi.model.api.PersistentModel;
import xapi.util.api.ErrorHandler;
import xapi.util.api.SuccessHandler;

@InstanceDefault(implFor=Model.class)
public class AbstractModel
implements Model,
PersistentModel,
NestedModel {
    private static StringTo<Object> defaultValues = X_Collect.newStringMap(Object.class);
    protected StringTo<Object> map = this.newStringMap();
    protected Model parent;
    protected ModelKey key;

    public AbstractModel() {
    }

    public AbstractModel(String type) {
        this.setKey(X_Model.newKey(type));
    }

    protected StringTo<Object> newStringMap() {
        return X_Collect.newStringMap(Object.class);
    }

    @Override
    public ModelKey getKey() {
        return this.key;
    }

    @Override
    public <T> T getProperty(String key) {
        Object val = this.map.get(key);
        if (val == null) {
            Class<?> type = this.getPropertyType(key);
            return (T)AbstractModel.getPrimitiveValue(type);
        }
        return (T)val;
    }

    @Override
    public <T> T getProperty(String key, T dflt) {
        Object val = this.map.get(key);
        if (val == null) {
            val = dflt;
        }
        if (val == null) {
            Class<?> type = this.getPropertyType(key);
            return (T)AbstractModel.getPrimitiveValue(type);
        }
        return (T)val;
    }

    @Override
    public Iterable<Map.Entry<String, Object>> getProperties() {
        return this.map.entries();
    }

    @Override
    public Model setProperty(String key, Object value) {
        try {
            this.map.put(key, value);
        }
        catch (Throwable e) {
            X_Log.error((Object[])new Object[]{e});
        }
        return this;
    }

    protected AbstractModel createNew() {
        return new AbstractModel();
    }

    @Override
    public Model removeProperty(String key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public Model child(String propName) {
        Object existing = this.map.get(propName);
        assert (existing == null || existing instanceof Model) : "You requested a child model with property name " + propName + ", but an object of type " + existing.getClass() + " already existed in this location: " + existing;
        if (existing == null) {
            AbstractModel child = this.createNew();
            child.parent = this;
            existing = child;
            this.map.put(propName, existing);
        }
        return (Model)existing;
    }

    @Override
    public Model parent() {
        return this.parent;
    }

    @Override
    public Model cache(SuccessHandler<Model> callback) {
        X_Model.cache().cacheModel(this, callback);
        return this;
    }

    @Override
    public Model persist(SuccessHandler<Model> callback) {
        X_Model.persist(this, callback);
        return this;
    }

    @Override
    public Model delete(SuccessHandler<Model> callback) {
        X_Model.cache().deleteModel(this, callback);
        return this;
    }

    @Override
    public Model load(SuccessHandler<Model> callback, boolean useCache) {
        block2: {
            try {
                Model model = X_Model.cache().getModel(this.getKey().toString());
                callback.onSuccess((Object)model);
            }
            catch (Exception e) {
                if (!(callback instanceof ErrorHandler)) break block2;
                ((ErrorHandler)callback).onError((Throwable)e);
            }
        }
        return this;
    }

    @Override
    public Model flush() {
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Class<?> getPropertyType(String key) {
        throw new UnsupportedOperationException("Type " + this.getClass() + " does not support .getPropertyType()");
    }

    @Override
    public String[] getPropertyNames() {
        throw new UnsupportedOperationException("Type " + this.getClass() + " does not support .getPropertyNames()");
    }

    public boolean equals(Object obj) {
        return AbstractModel.equalsForModel(this, obj);
    }

    public static boolean equalsForModel(Model self, Object obj) {
        if (obj instanceof Model) {
            Model theirModel = (Model)obj;
            ModelKey theirKey = theirModel.getKey();
            if (theirKey != null && self.getKey() != null) {
                return Objects.equals(self.getKey(), theirKey);
            }
            Object[] myProps = self.getPropertyNames();
            if (!Arrays.equals(theirModel.getPropertyNames(), myProps)) {
                return false;
            }
            for (Object key : myProps) {
                if (Objects.deepEquals(self.getProperty((String)key), theirModel.getProperty((String)key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return AbstractModel.hashCodeForModel(this);
    }

    public static int hashCodeForModel(Model m) {
        ModelKey k = m.getKey();
        if (k == null) {
            int hash = 27;
            for (String prop : m.getPropertyNames()) {
                Object value = m.getProperty(prop);
                if (value == null) {
                    hash += prop.hashCode();
                    continue;
                }
                Class<?> type = m.getPropertyType(prop);
                if (type.isArray()) {
                    hash += Array.getLength(value);
                    continue;
                }
                hash += prop.hashCode();
            }
            return hash;
        }
        return k.hashCode();
    }

    public String toString() {
        return AbstractModel.toStringForModel(this);
    }

    public static String toStringForModel(Model m) {
        StringBuilder b = new StringBuilder(m.getType() + "(\n");
        if (m.getKey() != null) {
            b.append("<").append(m.getKey()).append(">: ");
        }
        for (String name : m.getPropertyNames()) {
            Object value = m.getProperty(name);
            b.append(name).append(": ");
            if (value != null && value.getClass().isArray()) {
                AbstractModel.arrayToString(b, value);
            } else {
                b.append(value);
            }
            b.append('\t');
        }
        return b.append("\n)").toString();
    }

    private static void arrayToString(StringBuilder b, Object value) {
        b.append("[");
        int m = Array.getLength(value);
        for (int i = 0; i < m; ++i) {
            Object child = Array.get(value, i);
            if (child != null && child.getClass().isArray()) {
                AbstractModel.arrayToString(b, child);
            } else {
                b.append(child);
            }
            if (i >= m - 1) continue;
            b.append(", ");
        }
        b.append("]");
    }

    public static Object getPrimitiveValue(Class<?> type) {
        if (defaultValues.isEmpty()) {
            defaultValues.put(Boolean.TYPE.getName(), (Object)false);
            defaultValues.put(Byte.TYPE.getName(), (Object)0);
            defaultValues.put(Short.TYPE.getName(), (Object)0);
            defaultValues.put(Character.TYPE.getName(), (Object)Character.valueOf('\u0000'));
            defaultValues.put(Integer.TYPE.getName(), (Object)0);
            defaultValues.put(Long.TYPE.getName(), (Object)0L);
            defaultValues.put(Float.TYPE.getName(), (Object)Float.valueOf(0.0f));
            defaultValues.put(Double.TYPE.getName(), (Object)0.0);
        }
        return defaultValues.get(type.getName());
    }

    @Override
    public String getType() {
        if (this.getKey() == null) {
            throw new UnsupportedOperationException("Generic model " + this.getClass() + " does not have a key set. Cannot determine type.");
        }
        return this.getKey().getKind();
    }

    @Override
    public Model setKey(ModelKey key) {
        this.key = key;
        return this;
    }
}

