/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import java.util.Objects;
import xapi.annotation.gwt.MagicMethod;
import xapi.collect.X_Collect;
import xapi.collect.api.ClassTo;
import xapi.collect.api.StringTo;
import xapi.dev.source.CharBuffer;
import xapi.inject.X_Inject;
import xapi.model.api.Model;
import xapi.model.api.ModelDeserializationContext;
import xapi.model.api.ModelKey;
import xapi.model.api.ModelManifest;
import xapi.model.api.ModelSerializationContext;
import xapi.model.api.ModelSerializer;
import xapi.model.api.PrimitiveSerializer;
import xapi.model.impl.ModelKeyDefault;
import xapi.model.impl.ModelSerializerDefault;
import xapi.model.impl.ModelUtil;
import xapi.model.impl.PrimitiveSerializerDefault;
import xapi.model.service.ModelService;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;
import xapi.util.api.SuccessHandler;

public abstract class AbstractModelService
implements ModelService {
    protected final StringTo<ModelSerializer> serializers = X_Collect.newStringMap(ModelSerializer.class);
    protected final ClassTo<String> classToTypeName = X_Collect.newClassMap(String.class);
    protected final StringTo<Class<? extends Model>> typeNameToClass = X_Collect.newStringMap((Class)((Class)Class.class.cast(Class.class)));

    @Override
    @MagicMethod(doNotVisit=true, documentation="This magic method re-routes to the same provider as X_Inject.instance()")
    public <T extends Model> T create(Class<T> key) {
        Model instance = (Model)X_Inject.instance(key);
        if (instance == null) {
            return null;
        }
        this.typeNameToClass.put(instance.getType(), key);
        this.classToTypeName.put(key, (Object)instance.getType());
        return (T)instance;
    }

    @Override
    public <M extends Model> void persist(M model, SuccessHandler<M> callback) {
        assert (Objects.nonNull(model)) : "Cannot persist a null model";
        this.doPersist(model.getType(), model, callback);
    }

    protected abstract <M extends Model> void doPersist(String var1, M var2, SuccessHandler<M> var3);

    protected <M extends Model> M deserialize(String cls, CharIterator model) {
        return this.deserialize((Class)this.typeNameToClass.get(cls), model);
    }

    @Override
    public <M extends Model> M deserialize(Class<M> cls, CharIterator model) {
        if (model == null) {
            return null;
        }
        ModelDeserializationContext context = new ModelDeserializationContext((Model)this.create(cls), model, this, null);
        context.setClientToServer(this.isClientToServer());
        ModelSerializer<M> serializer = this.getSerializer(this.getTypeName(cls));
        return serializer.modelFromString(model, context);
    }

    protected boolean isClientToServer() {
        return false;
    }

    @Override
    public <M extends Model> M deserialize(ModelManifest manifest, CharIterator model) {
        if (model == null) {
            return null;
        }
        Class cls = (Class)this.typeNameToClass.get(manifest.getType());
        ModelDeserializationContext context = new ModelDeserializationContext((Model)this.create(cls), model, this, manifest);
        context.setClientToServer(this.isClientToServer());
        ModelSerializer<M> serializer = this.getSerializer(manifest.getType());
        return serializer.modelFromString(model, context);
    }

    @Override
    public PrimitiveSerializer primitiveSerializer() {
        return new PrimitiveSerializerDefault();
    }

    protected String getTypeName(Class<? extends Model> cls) {
        String known = (String)this.classToTypeName.get(cls);
        if (known != null) {
            return known;
        }
        if (!cls.isInterface()) {
            Class<Model> winner = cls;
            for (Class<?> iface : cls.getInterfaces()) {
                if (!Model.class.isAssignableFrom(iface) || winner != cls && !winner.isAssignableFrom(iface)) continue;
                winner = iface;
            }
            if (winner != cls && (known = (String)this.classToTypeName.get(winner)) != null) {
                this.classToTypeName.put(cls, (Object)known);
                this.typeNameToClass.put(known, cls);
                return known;
            }
        }
        String name = ModelUtil.guessModelType(cls);
        this.classToTypeName.put(cls, (Object)name);
        this.typeNameToClass.put(name, cls);
        return name;
    }

    protected <M extends Model> ModelSerializer<M> getSerializer(String type) {
        ModelSerializer serializer = (ModelSerializer)this.serializers.get(type);
        if (serializer == null) {
            serializer = this.getDefaultSerializer(type);
        }
        return serializer;
    }

    protected <M extends Model> ModelSerializer getDefaultSerializer(String type) {
        return new ModelSerializerDefault();
    }

    @Override
    public <M extends Model> CharBuffer serialize(Class<M> cls, M model) {
        return this.serialize(this.getTypeName(cls), model);
    }

    protected <M extends Model> CharBuffer serialize(String type, M model) {
        if (model == null) {
            return null;
        }
        CharBuffer buffer = new CharBuffer();
        ModelSerializationContext context = new ModelSerializationContext(buffer, this, null);
        context.setClientToServer(this.isClientToServer());
        return this.getSerializer(type).modelToString(model, context);
    }

    @Override
    public <M extends Model> CharBuffer serialize(ModelManifest manifest, M model) {
        if (model == null) {
            return null;
        }
        CharBuffer buffer = new CharBuffer();
        ModelSerializationContext context = new ModelSerializationContext(buffer, this, manifest);
        context.setClientToServer(this.isClientToServer());
        ModelSerializer<M> serializer = this.getSerializer(manifest.getType());
        return serializer.modelToString(model, context);
    }

    @Override
    public String register(Class<? extends Model> model) {
        String typeName = this.getTypeName(model);
        this.classToTypeName.put(model, (Object)typeName);
        this.typeNameToClass.put(typeName, model);
        ModelSerializer serializer = this.getSerializer(typeName);
        this.serializers.put(typeName, serializer);
        return typeName;
    }

    @Override
    public ModelKey keyFromString(String key) {
        StringCharIterator chars = new StringCharIterator(key);
        PrimitiveSerializer primitives = this.primitiveSerializer();
        return this.deserializeKey((CharIterator)chars, primitives);
    }

    protected ModelKey deserializeKey(CharIterator chars, PrimitiveSerializer primitives) {
        ModelKey parent = null;
        if (!chars.hasNext()) {
            return null;
        }
        int parentState = primitives.deserializeInt(chars);
        if (parentState == -1) {
            String namespace = primitives.deserializeString(chars);
            String kind = primitives.deserializeString(chars);
            int keyType = primitives.deserializeInt(chars);
            String id = primitives.deserializeString(chars);
            return this.newKey(namespace, kind, id).setKeyType(keyType);
        }
        String parentString = chars.consume(parentState).toString();
        assert (parentString != null);
        parent = this.keyFromString(parentString);
        String kind = primitives.deserializeString(chars);
        int keyType = primitives.deserializeInt(chars);
        String id = primitives.deserializeString(chars);
        return parent.getChild(kind, id).setKeyType(keyType);
    }

    @Override
    public String keyToString(ModelKey key) {
        StringBuilder b = new StringBuilder();
        PrimitiveSerializer primitives = this.primitiveSerializer();
        if (key.getParent() == null) {
            b.append(primitives.serializeInt(-1));
            b.append(primitives.serializeString(key.getNamespace()));
        } else {
            b.append(primitives.serializeString(this.keyToString(key.getParent())));
        }
        b.append(primitives.serializeString(key.getKind()));
        b.append(primitives.serializeInt(key.getKeyType()));
        b.append(primitives.serializeString(key.getId()));
        return b.toString();
    }

    @Override
    public ModelKey newKey(String namespace, String kind) {
        return new ModelKeyDefault(namespace, kind);
    }

    @Override
    public ModelKey newKey(String namespace, String kind, String id) {
        return new ModelKeyDefault(namespace, kind, id);
    }
}

