/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import java.util.Objects;
import xapi.annotation.inject.InstanceDefault;
import xapi.model.X_Model;
import xapi.model.api.ModelKey;

@InstanceDefault(implFor=ModelKey.class)
public class ModelKeyDefault
implements ModelKey {
    private ModelKey parentKey;
    private final String kind;
    private final String namespace;
    private String id;
    private int keyType;

    public ModelKeyDefault(String namespace, String kind) {
        assert (kind != null) : "Model Key must NEVER have a null kind";
        this.namespace = namespace == null ? "" : namespace;
        this.kind = kind;
    }

    public ModelKeyDefault(String namespace, String kind, String id) {
        this(namespace, kind);
        this.id = id;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ModelKey getParent() {
        return this.parentKey;
    }

    @Override
    public boolean isComplete() {
        return this.id != null && !this.id.isEmpty();
    }

    @Override
    public ModelKey getChild(String kind, String id) {
        ModelKeyDefault key = new ModelKeyDefault(this.namespace, kind, id);
        key.parentKey = this;
        return key;
    }

    @Override
    public ModelKey setId(String id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return X_Model.keyToString(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelKey) {
            ModelKey asKey = (ModelKey)obj;
            if (!Objects.equals(this.getNamespace(), asKey.getNamespace())) {
                return false;
            }
            if (!Objects.equals(this.getKind(), asKey.getKind())) {
                return false;
            }
            return Objects.equals(this.getId(), asKey.getId());
        }
        return false;
    }

    public int hashCode() {
        int hash = 37;
        if (this.namespace != null) {
            hash += this.namespace.hashCode();
        }
        hash ^= ~this.kind.hashCode();
        if (this.id != null) {
            hash += this.id.hashCode();
        }
        return hash;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public ModelKeyDefault setKeyType(int keyType) {
        this.keyType = keyType;
        return this;
    }
}

