/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import xapi.dev.source.CharBuffer;
import xapi.log.X_Log;
import xapi.model.api.Model;
import xapi.model.api.ModelDeserializationContext;
import xapi.model.api.ModelKey;
import xapi.model.api.ModelManifest;
import xapi.model.api.ModelSerializationContext;
import xapi.model.api.ModelSerializer;
import xapi.model.api.PrimitiveReader;
import xapi.model.api.PrimitiveSerializer;
import xapi.model.impl.PrimitiveReaders;
import xapi.source.api.CharIterator;
import xapi.util.X_Debug;

public class ModelSerializerDefault<M extends Model>
implements ModelSerializer<M> {
    private final Map<Class<?>, PrimitiveReader> primitiveReaders;

    public ModelSerializerDefault() {
        this(new HashMap());
    }

    public ModelSerializerDefault(Map<Class<?>, PrimitiveReader> primitiveReaders) {
        this.primitiveReaders = primitiveReaders;
    }

    @Override
    public CharBuffer modelToString(M model, ModelSerializationContext ctx) {
        CharBuffer out = new CharBuffer();
        ctx.getBuffer().addToEnd(out);
        this.write(model, out, ctx);
        return out;
    }

    protected void write(M model, CharBuffer out, ModelSerializationContext ctx) {
        PrimitiveSerializer primitives = ctx.getPrimitives();
        if (model == null) {
            out.append(primitives.serializeInt(-2));
            return;
        }
        ModelKey modelKey = model.getKey();
        if (modelKey == null) {
            out.append(primitives.serializeInt(-1));
        } else {
            String keyString = ctx.getService().keyToString(modelKey);
            out.append(primitives.serializeString(keyString));
        }
        for (String key : model.getPropertyNames()) {
            if (this.preventSerialization(model, key, ctx)) continue;
            Object value = model.getProperty(key);
            Class<?> propertyType = model.getPropertyType(key);
            if (propertyType.isArray()) {
                this.writeArray(out, propertyType, value, primitives, ctx);
                continue;
            }
            if (propertyType == String.class) {
                String asString = (String)value;
                this.writeString(out, asString, primitives);
                continue;
            }
            if (propertyType.isPrimitive()) {
                if (propertyType == Double.TYPE) {
                    Double asDouble = (Double)value;
                    if (asDouble == null) {
                        asDouble = 0.0;
                    }
                    out.append(primitives.serializeDouble(asDouble));
                    continue;
                }
                if (propertyType == Float.TYPE) {
                    Float asFloat = (Float)value;
                    if (asFloat == null) {
                        asFloat = Float.valueOf(0.0f);
                    }
                    out.append(primitives.serializeFloat(asFloat.floatValue()));
                    continue;
                }
                if (propertyType == Long.TYPE) {
                    Long asLong = (Long)value;
                    if (asLong == null) {
                        asLong = 0L;
                    }
                    out.append(primitives.serializeLong(asLong));
                    continue;
                }
                Number asNumber = (Number)value;
                if (asNumber == null) {
                    asNumber = 0;
                }
                out.append(primitives.serializeInt(asNumber.intValue()));
                continue;
            }
            if (this.isModelType(propertyType)) {
                this.writeModel(out, propertyType, (Model)value, primitives, ctx);
                continue;
            }
            if (this.isSupportedEnumType(propertyType)) {
                if (value == null) {
                    out.append(primitives.serializeInt(-1));
                    continue;
                }
                Enum asEnum = (Enum)value;
                out.append(primitives.serializeInt(asEnum.ordinal()));
                continue;
            }
            assert (false) : "Unserializable field type: " + propertyType;
        }
    }

    protected boolean preventSerialization(M model, String key, ModelSerializationContext ctx) {
        if (ctx.getManifest() == null) {
            return false;
        }
        ModelManifest manifest = ctx.getManifest();
        assert (manifest.getMethodData(key) != null) : "Invalid manifest; no data found for " + model.getType() + "." + key;
        if (ctx.isClientToServer()) {
            return !manifest.isClientToServerEnabled(key);
        }
        return !manifest.isServerToClientEnabled(key);
    }

    protected boolean preventDeserialization(M model, String key, ModelDeserializationContext ctx) {
        if (ctx.getManifest() == null) {
            return false;
        }
        ModelManifest manifest = ctx.getManifest();
        assert (manifest.getMethodData(key) != null) : "Invalid manifest; no data found for " + model.getType() + "." + key;
        if (ctx.isClientToServer()) {
            return !manifest.isServerToClientEnabled(key);
        }
        return !manifest.isClientToServerEnabled(key);
    }

    protected boolean isSupportedEnumType(Class<?> propertyType) {
        return propertyType.isEnum();
    }

    protected boolean isModelType(Class<?> propertyType) {
        return Model.class.isAssignableFrom(propertyType);
    }

    protected void writeArray(CharBuffer out, Class<?> propertyType, Object array, PrimitiveSerializer primitives, ModelSerializationContext ctx) {
        if (array == null) {
            out.append(primitives.serializeInt(-1));
            return;
        }
        int len = Array.getLength(array);
        String length = primitives.serializeInt(len);
        out.append(length);
        Class<?> childType = propertyType.getComponentType();
        if (childType.isPrimitive()) {
            if (childType == Boolean.TYPE) {
                out.append(primitives.serializeBooleanArray((boolean[])array));
            } else if (childType == Double.TYPE) {
                for (int i = 0; i < len; ++i) {
                    out.append(primitives.serializeDouble(Array.getDouble(array, i)));
                }
            } else if (childType == Float.TYPE) {
                for (int i = 0; i < len; ++i) {
                    out.append(primitives.serializeFloat(Array.getFloat(array, i)));
                }
            } else if (childType == Long.TYPE) {
                for (int i = 0; i < len; ++i) {
                    out.append(primitives.serializeLong(Array.getLong(array, i)));
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    out.append(primitives.serializeInt(Array.getInt(array, i)));
                }
            }
        } else if (this.isModelType(childType)) {
            for (int i = 0; i < len; ++i) {
                Object model = Array.get(array, i);
                this.writeModel(out, childType, (Model)model, primitives, ctx);
            }
        } else if (childType == String.class) {
            for (int i = 0; i < len; ++i) {
                this.writeString(out, (String)Array.get(array, i), primitives);
            }
        } else if (this.isSupportedEnumType(childType)) {
            assert (childType != Enum.class) : this.getClass() + " does not support Enum[] values from model " + propertyType;
            for (int i = 0; i < len; ++i) {
                Enum asEnum = (Enum)Array.get(array, i);
                if (asEnum == null) {
                    out.append(primitives.serializeInt(-1));
                    continue;
                }
                out.append(primitives.serializeInt(asEnum.ordinal()));
            }
        } else if (childType.isArray()) {
            for (int i = 0; i < len; ++i) {
                this.writeArray(out, propertyType.getComponentType(), Array.get(array, i), primitives, ctx);
            }
        } else {
            throw new UnsupportedOperationException("Unable to serialize unsupported array type " + childType);
        }
    }

    protected void writeString(CharBuffer out, String string, PrimitiveSerializer primitives) {
        if (string == null) {
            out.append(primitives.serializeInt(-1));
        } else {
            out.append(primitives.serializeInt(string.length()));
            out.append(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeModel(CharBuffer out, Class<?> propertyType, Model childModel, PrimitiveSerializer primitives, ModelSerializationContext ctx) {
        ModelSerializer serializer = this.newSerializer((Class)Class.class.cast(propertyType), ctx);
        CharBuffer was = ctx.getBuffer();
        ctx.setBuffer(out);
        try {
            serializer.modelToString(childModel, ctx);
        }
        finally {
            ctx.setBuffer(was);
        }
    }

    protected <Mod extends Model> ModelSerializer<Mod> newSerializer(Class<Mod> propertyType, ModelSerializationContext ctx) {
        return new ModelSerializerDefault<M>(this.primitiveReaders);
    }

    @Override
    public M modelFromString(CharIterator src, ModelDeserializationContext ctx) {
        ModelKey key;
        PrimitiveSerializer primitives = ctx.getPrimitives();
        int modelState = primitives.deserializeInt(src);
        if (modelState == -2) {
            return null;
        }
        if (modelState > -1) {
            String keyString = src.consume(modelState).toString();
            key = ctx.getService().keyFromString(keyString);
        } else {
            key = null;
        }
        Model model = ctx.getModel();
        assert (model != null) : "Null model found " + src;
        model.setKey(key);
        for (String propertyName : model.getPropertyNames()) {
            if (this.preventDeserialization(model, propertyName, ctx)) continue;
            this.readProperty(model, propertyName, src, ctx);
        }
        return (M)model;
    }

    protected void readProperty(Model model, String propertyName, CharIterator src, ModelDeserializationContext ctx) {
        Class<?> propertyType = model.getPropertyType(propertyName);
        PrimitiveSerializer primitives = ctx.getPrimitives();
        if (propertyType.isArray()) {
            model.setProperty(propertyName, this.readArray(propertyType.getComponentType(), src, primitives, ctx));
        } else if (propertyType.isPrimitive()) {
            Object value = this.readPrimitive(propertyType, src, primitives);
            model.setProperty(propertyName, value);
        } else {
            Object value = this.readObject(propertyType, src, primitives, ctx);
            model.setProperty(propertyName, value);
        }
    }

    protected Object readArray(Class<?> componentType, CharIterator src, PrimitiveSerializer primitives, ModelDeserializationContext ctx) {
        int len = primitives.deserializeInt(src);
        if (len == -1) {
            return null;
        }
        if (componentType.isPrimitive()) {
            Object array = Array.newInstance(componentType, len);
            for (int i = 0; i < len; ++i) {
                if (componentType == Integer.TYPE) {
                    Array.setInt(array, i, primitives.deserializeInt(src));
                    continue;
                }
                if (componentType == Float.TYPE) {
                    Array.setFloat(array, i, primitives.deserializeFloat(src));
                    continue;
                }
                if (componentType == Boolean.TYPE) {
                    Array.setBoolean(array, i, primitives.deserializeBoolean(src));
                    continue;
                }
                if (componentType == Character.TYPE) {
                    Array.setChar(array, i, primitives.deserializeChar(src));
                    continue;
                }
                if (componentType == Double.TYPE) {
                    Array.setDouble(array, i, primitives.deserializeDouble(src));
                    continue;
                }
                if (componentType == Long.TYPE) {
                    Array.setLong(array, i, primitives.deserializeLong(src));
                    continue;
                }
                if (componentType == Short.TYPE) {
                    Array.setShort(array, i, primitives.deserializeShort(src));
                    continue;
                }
                if (componentType == Byte.TYPE) {
                    Array.setByte(array, i, primitives.deserializeByte(src));
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported array component type" + componentType);
            }
            return array;
        }
        Object array = Array.newInstance(componentType, len);
        for (int i = 0; i < len; ++i) {
            Object value = this.readObject(componentType, src, primitives, ctx);
            Array.set(array, i, value);
        }
        return array;
    }

    protected Object readPrimitive(Class<?> componentType, CharIterator src, PrimitiveSerializer primitives) {
        PrimitiveReader reader = this.getPrimitiveReader(componentType, this.primitiveReaders);
        return reader.readPrimitive(componentType, src, primitives);
    }

    protected PrimitiveReader getPrimitiveReader(Class<?> componentType, Map<Class<?>, PrimitiveReader> primitiveReaders) {
        PrimitiveReader reader = primitiveReaders.get(componentType);
        if (reader == null) {
            if (componentType == Integer.TYPE) {
                reader = PrimitiveReaders.forInt();
            } else if (componentType == Float.TYPE) {
                reader = PrimitiveReaders.forFloat();
            } else if (componentType == Boolean.TYPE) {
                reader = PrimitiveReaders.forBoolean();
            } else if (componentType == Character.TYPE) {
                reader = PrimitiveReaders.forChar();
            } else if (componentType == Double.TYPE) {
                reader = PrimitiveReaders.forDouble();
            } else if (componentType == Long.TYPE) {
                reader = PrimitiveReaders.forLong();
            } else if (componentType == Short.TYPE) {
                reader = PrimitiveReaders.forShort();
            } else if (componentType == Byte.TYPE) {
                reader = PrimitiveReaders.forByte();
            } else {
                throw new UnsupportedOperationException("Unsupported primitive type " + componentType);
            }
            primitiveReaders.put(componentType, reader);
        }
        return reader;
    }

    protected Object readObject(Class propertyType, CharIterator src, PrimitiveSerializer primitives, ModelDeserializationContext ctx) {
        if (propertyType == String.class) {
            int len = primitives.deserializeInt(src);
            if (len == -1) {
                return null;
            }
            return src.consume(len);
        }
        if (this.isModelType(propertyType)) {
            ModelDeserializationContext context = ctx.createChildContext(propertyType, src);
            return this.modelFromString(src, context);
        }
        if (propertyType.isArray()) {
            return this.readArray(propertyType.getComponentType(), src, primitives, ctx);
        }
        if (propertyType.isEnum()) {
            return this.readEnum(propertyType, src, primitives, ctx);
        }
        throw new UnsupportedOperationException("Unable to deserialize object of type " + propertyType);
    }

    protected Object readEnum(Class propertyType, CharIterator src, PrimitiveSerializer primitives, ModelDeserializationContext ctx) {
        try {
            int ordinal = primitives.deserializeInt(src);
            if (ordinal == -1) {
                return null;
            }
            Method method = propertyType.getMethod("values", new Class[0]);
            Object values = method.invoke(null, new Object[0]);
            return Array.get(values, ordinal);
        }
        catch (Throwable e) {
            X_Log.error((Object[])new Object[]{this.getClass(), "Error reading enum " + propertyType + " from " + src});
            throw X_Debug.rethrow((Throwable)e);
        }
    }
}

