/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import xapi.annotation.inject.InstanceDefault;
import xapi.model.api.PrimitiveSerializer;
import xapi.source.api.CharIterator;
import xapi.util.X_Debug;

@InstanceDefault(implFor=PrimitiveSerializer.class)
public class PrimitiveSerializerDefault
implements PrimitiveSerializer {
    private static final char NEGATIVE_VALUE_BOUNDARY = '=';
    private static final char END_VALUE_BOUNDARY = '^';
    private static final char[] CONTINUATION_NUM_SECTION = new char[]{'e', 't', 'a', 'o', 'i', 'n', 's', 'h', 'r', 'd', 'l', 'c', 'u', 'm', 'w', 'f', 'g', 'y', 'p', 'b', 'v', 'k', 'j', 'x', 'q', 'z', '_', '{', '}', '|', '~', '^', '`'};
    private static final char[] POSITIVE_NUM_ENDING = new char[]{'E', 'T', 'A', 'O', 'I', 'N', 'S', 'H', 'R', 'D', 'L', 'C', 'U', 'M', 'W', 'F', 'G', 'Y', 'P', 'B', 'V', 'K', 'J', 'X', 'Q', 'Z', '?', '@', '[', ']', '>', '\\'};
    private static final char[] NEGATIVE_NUM_ENDING = new char[]{'\u0000', ' ', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '.', ',', '-', '\'', '\"', '/', '*', '(', ')', ':', ';', '!', '+', '=', '#', '$', '%', '&', '<', '\t'};
    private static final int[] VALUE_TO_NUM = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 23, 16, 26, 27, 28, 29, 15, 19, 20, 18, 24, 13, 14, 12, 17, 10, 11, 2, 3, 4, 5, 6, 7, 8, 9, 21, 22, 30, 25, 30, 26, 27, 2, 19, 11, 9, 0, 15, 16, 7, 4, 22, 21, 10, 13, 5, 3, 18, 24, 8, 6, 1, 12, 20, 14, 23, 17, 25, 28, 31, 29, 31, 26, 32, 2, 19, 11, 9, 0, 15, 16, 7, 4, 22, 21, 10, 13, 5, 3, 18, 24, 8, 6, 1, 12, 20, 14, 23, 17, 25, 27, 29, 28, 30};
    private static final int[] BIT_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};

    private static int[] computeValueToNum() {
        int[] VALUE_TO_NUM = new int[127];
        char[] lookup = new char[127];
        int i = CONTINUATION_NUM_SECTION.length;
        while (i-- > 0) {
            VALUE_TO_NUM[PrimitiveSerializerDefault.CONTINUATION_NUM_SECTION[i]] = i;
            lookup[PrimitiveSerializerDefault.CONTINUATION_NUM_SECTION[i]] = CONTINUATION_NUM_SECTION[i];
        }
        i = POSITIVE_NUM_ENDING.length;
        while (i-- > 0) {
            VALUE_TO_NUM[PrimitiveSerializerDefault.POSITIVE_NUM_ENDING[i]] = i;
            lookup[PrimitiveSerializerDefault.POSITIVE_NUM_ENDING[i]] = POSITIVE_NUM_ENDING[i];
        }
        i = NEGATIVE_NUM_ENDING.length;
        while (i-- > 0) {
            VALUE_TO_NUM[PrimitiveSerializerDefault.NEGATIVE_NUM_ENDING[i]] = i;
            lookup[PrimitiveSerializerDefault.NEGATIVE_NUM_ENDING[i]] = NEGATIVE_NUM_ENDING[i];
        }
        StringBuilder b = new StringBuilder("= new int[] {\n");
        StringBuilder l = new StringBuilder();
        b.append("\n   ");
        l.append("\n// ");
        for (int i2 = 0; i2 < VALUE_TO_NUM.length; ++i2) {
            int pos = VALUE_TO_NUM[i2];
            char val = (char)i2;
            String num = Integer.toString(pos);
            if (num.length() == 1) {
                num = " " + num;
            }
            if (pos == 0) {
                l.append("    ");
            } else if (val == '\t') {
                l.append("\\t  ");
            } else if (val == ' ') {
                l.append("' ' ");
            } else {
                l.append(" " + (char)val + "  ");
            }
            b.append(num).append(", ");
            if (i2 == VALUE_TO_NUM.length - 1) {
                b.append("            ");
                i2 += 3;
            }
            if (i2 % 10 == 9) {
                b.append(" // " + (i2 - 9) + " - " + (i2 + 1));
                b.append((CharSequence)l);
                l.setLength(0);
                l.append("\n// ");
                b.append("\n\n   ");
                continue;
            }
            if (i2 % 5 != 4) continue;
            b.append(" ");
            l.append(" ");
        }
        System.out.println(b);
        return VALUE_TO_NUM;
    }

    @Override
    public int deserializeInt(CharIterator i) {
        int value = 0;
        int multi = 1;
        while (i.hasNext()) {
            char c = i.next();
            int delta = multi * VALUE_TO_NUM[c];
            assert (delta >= 0) : "Unexpected Integer overlow";
            if (c < '^') {
                if (c > '=') {
                    return value + delta;
                }
                return -value - delta;
            }
            value += delta;
            multi <<= 5;
        }
        assert (false) : "Malformed encoded number: " + i;
        return value;
    }

    @Override
    public long deserializeLong(CharIterator l) {
        long value = 0L;
        long multi = 1L;
        while (l.hasNext()) {
            char c = l.next();
            long delta = (long)VALUE_TO_NUM[c] * multi;
            assert (delta >= 0L) : "Unexpected Long overlow";
            if (c < '^') {
                if (c > '=') {
                    return value + delta;
                }
                return -value - delta;
            }
            value += delta;
            multi <<= 5;
        }
        assert (false) : "Malformed encoded number: " + l;
        return value;
    }

    @Override
    public String serializeInt(int i) {
        CharacterBuffer buffer = this.computeSerialization(i);
        char[] data = new char[buffer.slot];
        buffer.slot = 0;
        while (buffer != null) {
            data[buffer.slot] = buffer.c;
            buffer = buffer.next;
        }
        return String.valueOf(data);
    }

    @Override
    public String serializeLong(long l) {
        CharacterBuffer buffer = this.computeSerialization(l);
        char[] data = new char[buffer.slot];
        buffer.slot = 0;
        while (buffer != null) {
            data[buffer.slot] = buffer.c;
            buffer = buffer.next;
        }
        return String.valueOf(data);
    }

    protected CharacterBuffer computeSerialization(int i) {
        boolean negative;
        CharacterBuffer head;
        CharacterBuffer tail = head = new CharacterBuffer();
        if (i < 0) {
            negative = true;
            if (i == Integer.MIN_VALUE) {
                tail = this.pushItem(1, 32, head, tail);
                i = i / -32 - 1;
            } else {
                i = -i;
            }
            assert (i >= 0);
        } else {
            negative = false;
        }
        int pos = head.slot + 1;
        while (true) {
            int chunk = i % 32;
            if ((i /= 32) == 0) {
                ++head.slot;
                tail.c = negative ? NEGATIVE_NUM_ENDING[chunk] : POSITIVE_NUM_ENDING[chunk];
                return head;
            }
            tail = this.pushItem(pos, chunk, head, tail);
            ++pos;
        }
    }

    private CharacterBuffer pushItem(int slot, int value, CharacterBuffer head, CharacterBuffer tail) {
        tail.c = CONTINUATION_NUM_SECTION[value];
        ++head.slot;
        CharacterBuffer next = new CharacterBuffer();
        next.slot = slot;
        tail.next = next;
        tail = next;
        return next;
    }

    private CharacterBuffer computeSerialization(long i) {
        boolean negative;
        CharacterBuffer head;
        CharacterBuffer tail = head = new CharacterBuffer();
        if (i < 0L) {
            negative = true;
            if (i == Long.MIN_VALUE) {
                tail = this.pushItem(1, 32, head, tail);
                i = i / -32L - 1L;
            } else {
                i = -i;
            }
            assert (i >= 0L);
        } else {
            negative = false;
        }
        int pos = head.slot + 1;
        while (true) {
            int chunk = (int)(i % 32L);
            if ((i /= 32L) == 0L) {
                ++head.slot;
                tail.c = negative ? NEGATIVE_NUM_ENDING[chunk] : POSITIVE_NUM_ENDING[chunk];
                return head;
            }
            tail = this.pushItem(pos, chunk, head, tail);
            ++pos;
        }
    }

    @Override
    public String serializeBoolean(boolean z) {
        return z ? "1" : "0";
    }

    @Override
    public String serializeBooleanArray(boolean ... z) {
        int size = z.length / 5 + 1;
        CharacterBuffer sizeChunk = this.computeSerialization(z.length);
        int offset = sizeChunk.slot;
        char[] buffer = new char[size + offset];
        sizeChunk.slot = 0;
        while (sizeChunk != null) {
            buffer[sizeChunk.slot] = sizeChunk.c;
            sizeChunk = sizeChunk.next;
        }
        for (int i = 0; i < size; ++i) {
            int value = this.boolsToBase32(z, i);
            assert (value < 32);
            buffer[i + offset] = POSITIVE_NUM_ENDING[value % 32];
        }
        return String.valueOf(buffer);
    }

    private int boolsToBase32(boolean[] z, int pos) {
        int value = 0;
        if (pos + 5 >= z.length) {
            int start = pos;
            while (pos < z.length) {
                if (z[pos]) {
                    value += BIT_MASKS[pos - start];
                }
                ++pos;
            }
            return value;
        }
        if (z[pos++]) {
            ++value;
        }
        if (z[pos++]) {
            value += 2;
        }
        if (z[pos++]) {
            value += 4;
        }
        if (z[pos++]) {
            value += 8;
        }
        if (z[pos++]) {
            value += 16;
        }
        return value;
    }

    @Override
    public String serializeByte(byte b) {
        return this.serializeInt(b);
    }

    @Override
    public String serializeShort(short s) {
        return this.serializeInt(s);
    }

    @Override
    public String serializeChar(char c) {
        return this.serializeInt(c);
    }

    @Override
    public String serializeFloat(float f) {
        return this.serializeInt(Float.floatToIntBits(f));
    }

    @Override
    public String serializeDouble(double d) {
        return this.serializeLong(Double.doubleToLongBits(d));
    }

    @Override
    public boolean deserializeBoolean(CharIterator z) {
        return z.next() == '1';
    }

    @Override
    public boolean[] deserializeBooleanArray(CharIterator z) {
        int size = this.deserializeInt(z);
        boolean[] result = new boolean[size];
        int i = 0;
        while (true) {
            int value = this.deserializeInt(z);
            if (i + 5 > size) {
                int start = i;
                while (i < size) {
                    result[i] = (value & BIT_MASKS[i - start]) != 0;
                    ++i;
                }
                break;
            }
            result[i++] = (value & 1) != 0;
            result[i++] = (value & 2) != 0;
            result[i++] = (value & 4) != 0;
            result[i++] = (value & 8) != 0;
            result[i++] = (value & 0x10) != 0;
        }
        return result;
    }

    @Override
    public byte deserializeByte(CharIterator b) {
        return (byte)this.deserializeInt(b);
    }

    @Override
    public short deserializeShort(CharIterator s) {
        return (short)this.deserializeInt(s);
    }

    @Override
    public char deserializeChar(CharIterator c) {
        return (char)this.deserializeInt(c);
    }

    @Override
    public float deserializeFloat(CharIterator f) {
        int asInt = this.deserializeInt(f);
        return Float.intBitsToFloat(asInt);
    }

    @Override
    public double deserializeDouble(CharIterator d) {
        long asLong = this.deserializeLong(d);
        return Double.longBitsToDouble(asLong);
    }

    @Override
    public String deserializeString(CharIterator s) {
        int size = this.deserializeInt(s);
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return "";
        }
        return s.consume(size).toString();
    }

    @Override
    public String serializeString(String s) {
        if (s == null) {
            return this.serializeInt(-1);
        }
        return this.serializeInt(s.length()) + s;
    }

    @Override
    public String serializeClass(Class<?> c) {
        return this.serializeString(c.getName());
    }

    public Class<?> deserializeClass(CharIterator c) {
        String cls = this.deserializeString(c);
        return this.loadClass(cls);
    }

    public Class<?> loadClass(String cls) {
        if (cls == null) {
            return null;
        }
        switch (cls) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return Class.forName(cls);
        }
        catch (ClassNotFoundException e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    protected static class CharacterBuffer {
        protected CharacterBuffer next;
        protected int slot;
        protected char c;

        protected CharacterBuffer() {
        }
    }
}

