/*
 * Decompiled with CFR 0.152.
 */
package xapi.ui.api;

import java.io.IOException;
import xapi.ui.api.Widget;
import xapi.util.X_Debug;
import xapi.util.impl.DeferredCharSequence;

public abstract class NodeBuilder<E>
implements Widget<E> {
    protected static final String EMPTY = "";
    private CharSequence buffer;
    protected NodeBuilder<E> children;
    protected NodeBuilder<E> siblings;
    protected E el;
    private NodeBuilder childTarget = this;

    public <C extends NodeBuilder<E>> C addChild(C child) {
        return this.addChild(child, false);
    }

    public <C extends NodeBuilder<E>> C addChild(C child, boolean makeTarget) {
        if (this.buffer != null) {
            CharSequence was = this.buffer;
            this.buffer = null;
            this.addChild0(this.wrapChars(was));
        }
        this.childTarget.addChild0(child);
        if (makeTarget) {
            this.childTarget = child;
        }
        return child;
    }

    private <C extends NodeBuilder<E>> void addChild0(C child) {
        if (this.children == null) {
            this.children = child;
        } else {
            assert (this.children != child);
            this.children.addSibling(child);
        }
    }

    public void clearChildren() {
        this.buffer = null;
        this.children = null;
    }

    public void clearAll() {
        this.clearChildren();
        this.siblings = null;
        this.el = null;
    }

    public <C extends NodeBuilder<E>> C addSibling(C sibling) {
        if (this.siblings == null) {
            this.siblings = sibling;
        } else {
            this.siblings.addSibling(sibling);
        }
        return sibling;
    }

    public NodeBuilder<E> append(CharSequence chars) {
        if (this.children == null) {
            this.buffer = this.buffer == null ? chars : this.join(this.buffer, chars);
        } else if (chars != null && chars != EMPTY) {
            this.addChild0(this.wrapChars(chars));
        }
        return this;
    }

    protected abstract E create(CharSequence var1);

    protected CharSequence getCharsAfter(CharSequence self) {
        return EMPTY;
    }

    protected CharSequence getCharsBefore() {
        return EMPTY;
    }

    @Override
    public E getElement() {
        return this.el == null ? this.initialize() : this.el;
    }

    private final E initialize() {
        StringBuilder b = new StringBuilder();
        this.toHtml(b);
        this.el = this.create(b.toString());
        this.onInitialize(this.el);
        return this.el;
    }

    protected void onInitialize(E el) {
    }

    protected CharSequence join(CharSequence body, CharSequence chars) {
        return new DeferredCharSequence(body, chars);
    }

    protected void toHtml(Appendable out) {
        CharSequence after;
        boolean printChars;
        CharSequence chars = this.getCharsBefore();
        boolean bl = printChars = chars != null && chars != EMPTY;
        if (printChars) {
            this.print(out, chars);
        }
        if (this.children == null) {
            if (this.buffer != null && this.buffer != EMPTY) {
                this.print(out, this.buffer);
            }
        } else {
            if (this.buffer != null && this.buffer != EMPTY) {
                this.addChild0(this.wrapChars(this.buffer));
            }
            this.children.toHtml(out);
        }
        if (printChars && (after = this.getCharsAfter(chars)) != null && after != EMPTY) {
            this.print(out, after);
        }
        if (this.siblings != null) {
            this.siblings.toHtml(out);
        }
    }

    protected void print(Appendable out, CharSequence was) {
        try {
            out.append(was);
        }
        catch (IOException e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    protected abstract NodeBuilder<E> wrapChars(CharSequence var1);

    protected boolean isChildrenEmpty() {
        return this.children == null && this.buffer == null;
    }
}

