/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import xapi.bytecode.ClassFile;
import xapi.dev.X_Dev;
import xapi.dev.resource.impl.StringDataResource;
import xapi.dev.scanner.api.ClasspathScanner;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.inject.X_Inject;
import xapi.util.X_String;

public class X_Scanner {
    private X_Scanner() {
    }

    public static ClasspathResourceMap scanClassloader(ClassLoader cl) {
        return X_Scanner.scanAll().scan(cl);
    }

    public static Callable<ClasspathResourceMap> scanClassloaderAsync(ClassLoader cl) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchClassFile(".*").matchResource(".*").matchSourceFile(".*").scanPackage("").scan(cl, Executors.newCachedThreadPool());
    }

    private static ClasspathScanner scanAll() {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchClassFile(".*").matchResource(".*").matchSourceFile(".*").scanPackage("");
    }

    public static ClasspathResourceMap scanClassloader(ClassLoader cl, boolean scanClasses, boolean scanSources, boolean scanResources, String pkg) {
        ClasspathScanner scanner = (ClasspathScanner)X_Inject.instance(ClasspathScanner.class);
        if (scanClasses) {
            scanner.matchClassFile(".*");
        }
        if (scanResources) {
            scanner.matchResource(".*");
        }
        if (scanSources) {
            scanner.matchSourceFile(".*");
        }
        scanner.scanPackage(X_String.notNull((String)pkg));
        return scanner.scan(cl);
    }

    public static Iterable<StringDataResource> findPoms(ClassLoader cl) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchResource(".*pom.*xml").scanPackage("").scan(cl).findResources("", new Pattern[0]);
    }

    public static Iterable<StringDataResource> findGwtXml(ClassLoader cl) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchResource(".*gwt.*xml").scanPackage("").scan(cl).findResources("", new Pattern[0]);
    }

    public static Iterable<ClassFile> findEnums(ClassLoader cl) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchClassFile(".*").scanPackage("").scan(cl).findDirectSubclasses(Enum.class);
    }

    @SafeVarargs
    public static Iterable<ClassFile> findMethodsWithAnnotations(ClassLoader cl, Class<? extends Annotation> ... annoClass) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchClassFile(".*").scanPackage("").scan(cl).findClassWithAnnotatedMethods(annoClass);
    }

    public static ClasspathResourceMap scanFolder(String url) {
        return X_Scanner.scanClassloader(new URLClassLoader(new URL[]{X_Dev.toUrl((String)url)}));
    }

    public static ClasspathResourceMap scanFolder(String url, boolean scanClasses, boolean scanSources, boolean scanResources, String pkg) {
        return X_Scanner.scanClassloader(new URLClassLoader(new URL[]{X_Dev.toUrl((String)url)}), scanClasses, scanSources, scanResources, pkg);
    }

    public static Iterable<ClassFile> findDirectSubclasses(ClassLoader classLoader, Class<?> ... cls) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchClassFile(".*").scanPackage("").scan(classLoader).findDirectSubclasses(cls);
    }

    public static Iterable<ClassFile> findImplementationsOf(ClassLoader classLoader, Class<?> ... cls) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchClassFile(".*").scanPackage("").scan(classLoader).findImplementationOf(cls);
    }

    public static Iterable<ClassFile> findClassesInPackage(ClassLoader classLoader, String pkgName) {
        return ((ClasspathScanner)X_Inject.instance(ClasspathScanner.class)).matchClassFile(".*").scanPackage("").scan(classLoader).findClassesInPackage(pkgName);
    }
}

