/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner.impl;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import xapi.bytecode.ClassFile;
import xapi.collect.api.Fifo;
import xapi.collect.api.HasPrefixed;
import xapi.collect.impl.SimpleFifo;
import xapi.dev.resource.impl.ByteCodeResource;
import xapi.dev.scanner.impl.ClassFileIterator;
import xapi.util.api.MatchesValue;

class AnnotatedClassIterator
implements Iterable<ClassFile>,
MatchesValue<ClassFile> {
    final Iterator<ClassFile> allClasses;
    Fifo<ClassFile> results = new SimpleFifo();
    boolean working = true;
    boolean waiting = false;

    public AnnotatedClassIterator(ExecutorService executor, HasPrefixed<ByteCodeResource> bytecode) {
        this.allClasses = new ClassFileIterator(this, bytecode).iterator();
        executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (AnnotatedClassIterator.this.allClasses.hasNext()) {
                        ClassFile next = AnnotatedClassIterator.this.allClasses.next();
                        AnnotatedClassIterator.this.results.give((Object)next);
                        if (!AnnotatedClassIterator.this.waiting) continue;
                        Iterator<ClassFile> iterator = AnnotatedClassIterator.this.allClasses;
                        synchronized (iterator) {
                            AnnotatedClassIterator.this.allClasses.notifyAll();
                        }
                        AnnotatedClassIterator.this.waiting = false;
                    }
                }
                finally {
                    AnnotatedClassIterator.this.working = false;
                }
                if (AnnotatedClassIterator.this.waiting) {
                    Iterator<ClassFile> iterator = AnnotatedClassIterator.this.allClasses;
                    synchronized (iterator) {
                        AnnotatedClassIterator.this.allClasses.notifyAll();
                    }
                }
            }
        });
    }

    @Override
    public Iterator<ClassFile> iterator() {
        return new Itr();
    }

    public boolean matches(ClassFile value) {
        return value.getAnnotations().length > 0;
    }

    class Itr
    implements Iterator<ClassFile> {
        Iterator<ClassFile> itr;

        Itr() {
            this.itr = AnnotatedClassIterator.this.results.forEach().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (AnnotatedClassIterator.this.working) {
                if (this.itr.hasNext()) {
                    return true;
                }
                try {
                    Iterator<ClassFile> iterator = AnnotatedClassIterator.this.allClasses;
                    synchronized (iterator) {
                        AnnotatedClassIterator.this.waiting = true;
                        AnnotatedClassIterator.this.allClasses.wait(0L, 25000);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            return this.itr.hasNext();
        }

        @Override
        public ClassFile next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

