/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner.impl;

import java.util.Iterator;
import xapi.bytecode.ClassFile;
import xapi.collect.api.HasPrefixed;
import xapi.dev.resource.impl.ByteCodeResource;
import xapi.util.api.MatchesValue;

class ClassFileIterator
implements Iterable<ClassFile> {
    private final MatchesValue<ClassFile> matcher;
    private final HasPrefixed<ByteCodeResource> bytecode;

    ClassFileIterator(MatchesValue<ClassFile> matcher, HasPrefixed<ByteCodeResource> bytecode) {
        assert (matcher != null);
        this.matcher = matcher;
        this.bytecode = bytecode;
    }

    @Override
    public Iterator<ClassFile> iterator() {
        return new Itr();
    }

    private final class Itr
    implements Iterator<ClassFile> {
        private Iterator<ByteCodeResource> iter;
        private ClassFile cls;

        private Itr() {
            this.iter = ClassFileIterator.this.bytecode.findPrefixed("").iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.iter.hasNext()) {
                this.cls = this.iter.next().getClassData();
                if (!ClassFileIterator.this.matcher.matches((Object)this.cls)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ClassFile next() {
            return this.cls;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

