/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner.impl;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import xapi.bytecode.ClassFile;
import xapi.bytecode.ClassPool;
import xapi.bytecode.FieldInfo;
import xapi.bytecode.MemberInfo;
import xapi.bytecode.MethodInfo;
import xapi.bytecode.NotFoundException;
import xapi.collect.api.Fifo;
import xapi.collect.api.HasPrefixed;
import xapi.collect.api.PrefixedMap;
import xapi.collect.impl.SimpleFifo;
import xapi.dev.resource.impl.ByteCodeResource;
import xapi.dev.resource.impl.SourceCodeResource;
import xapi.dev.resource.impl.StringDataResource;
import xapi.dev.scanner.impl.AnnotatedClassIterator;
import xapi.dev.scanner.impl.AnnotatedMethodIterator;
import xapi.dev.scanner.impl.ClassFileIterator;
import xapi.dev.scanner.impl.MatchesDirectSubclasses;
import xapi.dev.scanner.impl.MatchesImplementationsOf;
import xapi.dev.scanner.impl.ResourceTrie;
import xapi.log.X_Log;
import xapi.source.X_Source;
import xapi.util.X_Debug;
import xapi.util.api.MatchesValue;

public class ClasspathResourceMap {
    private final ResourceTrie<ByteCodeResource> bytecode;
    private final ResourceTrie<SourceCodeResource> sources;
    private final ResourceTrie<StringDataResource> resources;
    private final Set<Class<? extends Annotation>> annotations;
    private final Set<Pattern> bytecodeMatchers;
    private final ExecutorService executor;
    private final Set<Pattern> resourceMatchers;
    private final Set<Pattern> sourceMatchers;
    private final Fifo<ByteCodeResource> pending;
    private AnnotatedClassIterator allAnnos;
    private AnnotatedMethodIterator allMethodsWithAnnos;
    private ClassPool pool;
    private ArrayList<URL> classpath;

    public ClasspathResourceMap(ExecutorService executor, Set<Class<? extends Annotation>> annotations, Set<Pattern> bytecodeMatchers, Set<Pattern> resourceMatchers, Set<Pattern> sourceMatchers) {
        this.annotations = annotations;
        this.bytecodeMatchers = bytecodeMatchers;
        this.executor = executor;
        this.resourceMatchers = resourceMatchers;
        this.sourceMatchers = sourceMatchers;
        this.bytecode = new ResourceTrie();
        this.sources = new ResourceTrie();
        this.resources = new ResourceTrie();
        this.pending = new SimpleFifo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBytecode(String name, ByteCodeResource bytecode) {
        this.bytecode.put(X_Source.stripClassExtension((String)name.replace(File.separatorChar, '.')), (Object)bytecode);
        if (!this.preloadClasses()) {
            return;
        }
        if (this.pending.isEmpty()) {
            Fifo<ByteCodeResource> fifo = this.pending;
            synchronized (fifo) {
                if (this.pending.isEmpty()) {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            while (!ClasspathResourceMap.this.pending.isEmpty()) {
                                Iterator iter = ClasspathResourceMap.this.pending.iterator();
                                while (iter.hasNext()) {
                                    ClasspathResourceMap.this.addSubclasses(((ByteCodeResource)((Object)iter.next())).getClassData());
                                    iter.remove();
                                }
                            }
                        }
                    });
                }
                this.pending.give((Object)bytecode);
            }
        } else {
            this.pending.give((Object)bytecode);
        }
    }

    protected void addSubclasses(ClassFile classData) {
    }

    private boolean preloadClasses() {
        return !this.annotations.isEmpty() || !this.bytecodeMatchers.isEmpty();
    }

    protected void accept(String name, ByteCodeResource bytecode, Iterable<Class<? extends Annotation>> classAnnotations) {
        ClassFile classFile = bytecode.getClassData();
        for (Class<? extends Annotation> annoClass : classAnnotations) {
            this.maybeAccept(name, bytecode, classFile, annoClass);
        }
    }

    protected void maybeAccept(String name, ByteCodeResource bytecode, ClassFile classFile, Class<? extends Annotation> annoClass) {
        xapi.bytecode.annotation.Annotation anno = classFile.getAnnotation(annoClass.getName());
        if (anno != null) {
            this.bytecode.put(name, (Object)bytecode);
            return;
        }
        try {
            Target target = annoClass.getAnnotation(Target.class);
            ElementType[] targets = target == null ? this.getDefaultAnnotationTargets() : target.value();
            block7: for (ElementType type : targets) {
                switch (type) {
                    case METHOD: {
                        for (MethodInfo method : classFile.getMethods()) {
                            if (!this.accepts((MemberInfo)method, annoClass)) continue;
                            this.bytecode.put(name, (Object)bytecode);
                            return;
                        }
                        continue block7;
                    }
                    case FIELD: {
                        for (FieldInfo field : classFile.getFields()) {
                            if (!this.accepts((MemberInfo)field, annoClass)) continue;
                            this.bytecode.put(name, (Object)bytecode);
                            return;
                        }
                        continue block7;
                    }
                    case CONSTRUCTOR: {
                        for (MethodInfo method : classFile.getMethods()) {
                            if (!method.getName().contains("<init>") || !this.accepts((MemberInfo)method, annoClass)) continue;
                            this.bytecode.put(name, (Object)bytecode);
                            return;
                        }
                        continue block7;
                    }
                }
            }
        }
        catch (Throwable e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    private boolean accepts(MemberInfo method, Class<? extends Annotation> annoClass) {
        return method.getAnnotation(annoClass.getName()) != null;
    }

    protected ElementType[] getDefaultAnnotationTargets() {
        ElementType[] elementTypeArray;
        if (this.shouldScanMethods()) {
            ElementType[] elementTypeArray2 = new ElementType[1];
            elementTypeArray = elementTypeArray2;
            elementTypeArray2[0] = ElementType.METHOD;
        } else {
            elementTypeArray = new ElementType[]{};
        }
        return elementTypeArray;
    }

    protected boolean shouldScanMethods() {
        return this.allMethodsWithAnnos != null;
    }

    public void addSourcecode(String name, SourceCodeResource sourcecode) {
        this.sources.put(name, sourcecode);
    }

    public void addResource(String name, StringDataResource resource) {
        this.resources.put(name, resource);
    }

    public boolean includeResource(String name) {
        for (Pattern p : this.resourceMatchers) {
            if (p.matcher(name).matches()) {
                return true;
            }
            if (!p.matcher(name.substring(name.lastIndexOf(47) + 1)).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean includeSourcecode(String name) {
        for (Pattern p : this.sourceMatchers) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean includeBytecode(String name) {
        for (Pattern p : this.bytecodeMatchers) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public final SourceCodeResource findSource(String name) {
        return (SourceCodeResource)this.sources.get(name);
    }

    public final Iterable<SourceCodeResource> findSources(final String prefix, final Pattern ... patterns) {
        if (patterns.length == 0) {
            return this.sources.findPrefixed(prefix);
        }
        return new Iterable<SourceCodeResource>(){

            @Override
            public Iterator<SourceCodeResource> iterator() {
                class Itr
                implements Iterator<SourceCodeResource> {
                    SourceCodeResource cls;
                    Iterator<SourceCodeResource> iter;
                    final /* synthetic */ String val$prefix;
                    final /* synthetic */ Pattern[] val$patterns;

                    Itr() {
                        this.val$prefix = string;
                        this.val$patterns = patternArray;
                        this.iter = ClasspathResourceMap.this.sources.findPrefixed(this.val$prefix).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next();
                            for (Pattern pattern : this.val$patterns) {
                                if (!pattern.matcher(this.cls.getResourceName()).matches()) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    public SourceCodeResource next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, prefix, patterns);
            }
        };
    }

    public final StringDataResource findResource(String name) {
        return (StringDataResource)this.resources.get(name);
    }

    public final Iterable<StringDataResource> findResources(final String prefix, final Pattern ... patterns) {
        if (patterns.length == 0) {
            return this.resources.findPrefixed(prefix);
        }
        return new Iterable<StringDataResource>(){

            @Override
            public Iterator<StringDataResource> iterator() {
                class Itr
                implements Iterator<StringDataResource> {
                    StringDataResource cls;
                    Iterator<StringDataResource> iter;
                    final /* synthetic */ String val$prefix;
                    final /* synthetic */ Pattern[] val$patterns;

                    Itr() {
                        this.val$prefix = string;
                        this.val$patterns = patternArray;
                        this.iter = ClasspathResourceMap.this.resources.findPrefixed(this.val$prefix).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next();
                            for (Pattern pattern : this.val$patterns) {
                                if (!pattern.matcher(this.cls.getResourceName()).matches()) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    public StringDataResource next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, prefix, patterns);
            }
        };
    }

    public final ClassFile findClass(String clsName) {
        ByteCodeResource resource = (ByteCodeResource)((Object)this.bytecode.get(clsName = clsName.replace('/', '.')));
        return resource == null ? null : resource.getClassData();
    }

    public final Iterable<ClassFile> getAllClasses() {
        return new ClassFileIterator((MatchesValue<ClassFile>)MatchesValue.ANY, (HasPrefixed<ByteCodeResource>)this.bytecode);
    }

    public Iterable<ClassFile> findClassesInPackage(final String name) {
        return new ClassFileIterator(new MatchesValue<ClassFile>(){

            public boolean matches(ClassFile value) {
                return !"package-info".equals(value.getEnclosedName()) && value.getPackage().equals(name);
            }
        }, (HasPrefixed<ByteCodeResource>)this.bytecode);
    }

    public Iterable<ClassFile> findClassesBelowPackage(final String name) {
        return new ClassFileIterator(new MatchesValue<ClassFile>(){

            public boolean matches(ClassFile value) {
                return !"package-info".equals(value.getEnclosedName()) && value.getPackage().startsWith(name);
            }
        }, (HasPrefixed<ByteCodeResource>)this.bytecode);
    }

    public Iterable<ClassFile> findPackagesBelowPackage(final String name) {
        return new ClassFileIterator(new MatchesValue<ClassFile>(){

            public boolean matches(ClassFile value) {
                return "package-info".equals(value.getEnclosedName()) && value.getPackage().startsWith(name + ".");
            }
        }, (HasPrefixed<ByteCodeResource>)this.bytecode);
    }

    public final Iterable<ClassFile> findDirectSubclasses(Class<?> ... superClasses) {
        return this.findDirectSubclasses(X_Source.toStringBinary((Class[])superClasses));
    }

    public final Iterable<ClassFile> findDirectSubclasses(final String ... superClasses) {
        return new Iterable<ClassFile>(){

            @Override
            public Iterator<ClassFile> iterator() {
                class Itr
                implements Iterator<ClassFile> {
                    ClassFile cls;
                    Iterator<ByteCodeResource> iter;
                    final MatchesDirectSubclasses matcher;
                    final /* synthetic */ String[] val$superClasses;

                    Itr() {
                        this.val$superClasses = stringArray;
                        this.iter = ClasspathResourceMap.this.bytecode.findPrefixed("").iterator();
                        this.matcher = new MatchesDirectSubclasses(this.val$superClasses);
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next().getClassData();
                            if (!this.matcher.matches(this.cls)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public ClassFile next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, superClasses);
            }
        };
    }

    public final Iterable<ClassFile> findImplementationOf(Class<?> ... superClasses) {
        return this.findImplementationOf(X_Source.toStringBinary((Class[])superClasses));
    }

    public final Iterable<ClassFile> findImplementationOf(final String ... superClasses) {
        return new Iterable<ClassFile>(){

            @Override
            public Iterator<ClassFile> iterator() {
                class Itr
                implements Iterator<ClassFile> {
                    ClassFile cls;
                    Iterator<ByteCodeResource> iter;
                    final MatchesImplementationsOf matcher;
                    final /* synthetic */ String[] val$superClasses;

                    Itr() {
                        this.val$superClasses = stringArray;
                        this.iter = ClasspathResourceMap.this.bytecode.findPrefixed("").iterator();
                        this.matcher = new MatchesImplementationsOf((PrefixedMap<ByteCodeResource>)ClasspathResourceMap.this.bytecode, this.val$superClasses);
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next().getClassData();
                            if (!this.matcher.matches(this.cls)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public ClassFile next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, superClasses);
            }
        };
    }

    public final Iterable<ClassFile> findClassAnnotatedWith(final Class<? extends Annotation> ... annotations) {
        if (this.allAnnos == null) {
            this.allAnnos = new AnnotatedClassIterator(this.executor, (HasPrefixed<ByteCodeResource>)this.bytecode);
        }
        return new Iterable<ClassFile>(){

            @Override
            public Iterator<ClassFile> iterator() {
                class Itr
                implements Iterator<ClassFile> {
                    ClassFile cls;
                    Iterator<ClassFile> iter;
                    final /* synthetic */ Class[] val$annotations;

                    Itr() {
                        this.val$annotations = classArray;
                        this.iter = ClasspathResourceMap.this.allAnnos.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next();
                            for (Class annotation : this.val$annotations) {
                                if (this.cls.getAnnotation(annotation.getName()) == null) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    public ClassFile next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, annotations);
            }
        };
    }

    public final Iterable<ClassFile> findClassWithAnnotatedMethods(final Class<? extends Annotation> ... annotations) {
        if (this.allMethodsWithAnnos == null) {
            this.allMethodsWithAnnos = new AnnotatedMethodIterator(this.executor, this.bytecode);
        }
        return new Iterable<ClassFile>(){

            @Override
            public Iterator<ClassFile> iterator() {
                ClasspathResourceMap.this.preloadClasses();
                class Itr
                implements Iterator<ClassFile> {
                    ClassFile cls;
                    Iterator<ClassFile> iter;
                    final /* synthetic */ Class[] val$annotations;

                    Itr() {
                        this.val$annotations = classArray;
                        this.iter = ClasspathResourceMap.this.allMethodsWithAnnos.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next();
                            for (MethodInfo method : this.cls.getMethods()) {
                                if (!ClasspathResourceMap.this.allMethodsWithAnnos.scanMethod(method)) continue;
                                for (Class annotation : this.val$annotations) {
                                    if (method.getAnnotation(annotation.getName()) == null) continue;
                                    return true;
                                }
                            }
                        }
                        return false;
                    }

                    @Override
                    public ClassFile next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, annotations);
            }
        };
    }

    public ClassPool getClassPool() {
        if (this.pool == null) {
            this.pool = new ClassPool();
            for (URL cp : this.classpath) {
                int index;
                String asString = cp.toString();
                if (asString.endsWith("/")) {
                    asString = asString.substring(0, asString.length() - 1);
                }
                if (asString.startsWith("jar:")) {
                    asString = asString.substring(4);
                }
                if (asString.startsWith("file:/")) {
                    asString = asString.substring(6);
                }
                if ((index = asString.indexOf("jar!")) != -1) {
                    asString = asString.substring(0, index + 3);
                }
                try {
                    this.pool.appendClassPath(asString);
                }
                catch (NotFoundException e) {
                    X_Log.warn((Object[])new Object[]{this.getClass(), "Could not find resource " + cp, e});
                }
            }
        }
        return this.pool;
    }

    public void setClasspath(Set<URL> keySet) {
        this.classpath = new ArrayList<URL>(keySet);
    }
}

