/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import xapi.annotation.inject.InstanceDefault;
import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;
import xapi.dev.resource.api.ClasspathResource;
import xapi.dev.resource.impl.ByteCodeResource;
import xapi.dev.resource.impl.FileBackedResource;
import xapi.dev.resource.impl.JarBackedResource;
import xapi.dev.resource.impl.SourceCodeResource;
import xapi.dev.resource.impl.StringDataResource;
import xapi.dev.scanner.api.ClasspathScanner;
import xapi.dev.scanner.impl.ClasspathResourceMap;
import xapi.except.ThreadsafeUncaughtExceptionHandler;
import xapi.util.X_Debug;
import xapi.util.X_Properties;
import xapi.util.X_Util;

@InstanceDefault(implFor=ClasspathScanner.class)
public class ClasspathScannerDefault
implements ClasspathScanner {
    final Set<String> pkgs = new HashSet<String>();
    final Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
    final Set<Pattern> resourceMatchers = new HashSet<Pattern>();
    final Set<Pattern> bytecodeMatchers = new HashSet<Pattern>();
    final Set<Pattern> sourceMatchers = new HashSet<Pattern>();
    final Set<String> activeJars = new HashSet<String>();

    @Override
    public ClasspathScanner scanAnnotation(Class<? extends Annotation> annotation) {
        this.annotations.add(annotation);
        return this;
    }

    @Override
    public ClasspathScanner scanAnnotations(Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            this.annotations.add(annotation);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClasspathResourceMap scan(ClassLoader loaders) {
        ExecutorService executor = this.newExecutor();
        try {
            ClasspathResourceMap map;
            ClasspathResourceMap classpathResourceMap = map = this.scan(loaders, executor).call();
            synchronized (classpathResourceMap) {
                return map;
            }
        }
        catch (Exception e) {
            throw X_Debug.rethrow((Throwable)e);
        }
    }

    @Override
    public ExecutorService newExecutor() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 3 / 2);
    }

    @Override
    public synchronized Callable<ClasspathResourceMap> scan(ClassLoader loadFrom, ExecutorService executor) {
        LinkedHashMap<URL, Fifo> classPaths = new LinkedHashMap<URL, Fifo>();
        if (this.pkgs.size() == 0 || this.pkgs.size() == 1 && "".equals(this.pkgs.iterator().next())) {
            for (String pkg : X_Properties.getProperty((String)"xapi.inject.packages", (String)",META-INF,com,org,net,xapi,java").split(",\\s*")) {
                this.pkgs.add(pkg);
            }
        }
        for (String pkg : this.pkgs) {
            Enumeration<URL> resources;
            try {
                resources = loadFrom.getResources(pkg.equals(".*") ? "" : pkg.replace('.', '/'));
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                String file = resource.toExternalForm();
                if (file.contains("gwt-dev.jar")) continue;
                Fifo fifo = (Fifo)classPaths.get(resource);
                if (fifo == null) {
                    fifo = new SimpleFifo();
                    fifo.give((Object)pkg);
                    classPaths.put(resource, fifo);
                    continue;
                }
                fifo.remove((Object)pkg);
                fifo.give((Object)pkg);
            }
        }
        int pos = 0;
        ClasspathResourceMap map = new ClasspathResourceMap(executor, this.annotations, this.bytecodeMatchers, this.resourceMatchers, this.sourceMatchers);
        map.setClasspath(classPaths.keySet());
        SimpleFifo jobs = new SimpleFifo();
        for (URL url : classPaths.keySet()) {
            Fifo packages = (Fifo)classPaths.get(url);
            ScanRunner scanner = this.newScanRunner(url, map, executor, packages.forEach(), pos);
            jobs.give(executor.submit(scanner));
        }
        class Finisher
        implements Callable<ClasspathResourceMap> {
            final /* synthetic */ Fifo val$jobs;
            final /* synthetic */ ClasspathResourceMap val$map;

            Finisher() {
                this.val$jobs = fifo;
                this.val$map = classpathResourceMap;
            }

            @Override
            public ClasspathResourceMap call() throws Exception {
                while (!this.val$jobs.isEmpty()) {
                    Iterator iter = this.val$jobs.forEach().iterator();
                    while (iter.hasNext()) {
                        if (!((Future)iter.next()).isDone()) continue;
                        iter.remove();
                    }
                    try {
                        Thread.sleep(0L, 500);
                    }
                    catch (InterruptedException e) {
                        throw X_Debug.rethrow((Throwable)e);
                    }
                }
                return this.val$map;
            }
        }
        return new Finisher();
    }

    private ScanRunner newScanRunner(URL classPath, ClasspathResourceMap map, ExecutorService executor, Iterable<String> pkgs, int priority) {
        return new ScanRunner(classPath, pkgs, map, priority);
    }

    @Override
    public ClasspathScanner scanPackage(String pkg) {
        this.pkgs.add(pkg);
        return this;
    }

    @Override
    public ClasspathScanner scanPackages(String ... pkgs) {
        for (String pkg : pkgs) {
            this.pkgs.add(pkg);
        }
        return this;
    }

    @Override
    public ClasspathScanner matchClassFile(String regex) {
        this.bytecodeMatchers.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ClasspathScanner matchClassFiles(String ... regexes) {
        for (String regex : regexes) {
            this.bytecodeMatchers.add(Pattern.compile(regex));
        }
        return this;
    }

    @Override
    public ClasspathScanner matchResource(String regex) {
        this.resourceMatchers.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ClasspathScanner matchResources(String ... regexes) {
        for (String regex : regexes) {
            this.resourceMatchers.add(Pattern.compile(regex));
        }
        return this;
    }

    @Override
    public ClasspathScanner matchSourceFile(String regex) {
        this.sourceMatchers.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ClasspathScanner matchSourceFiles(String ... regexes) {
        for (String regex : regexes) {
            this.sourceMatchers.add(Pattern.compile(regex));
        }
        return this;
    }

    protected class ScanRunner
    implements Runnable {
        private final URL classpath;
        private final ClasspathResourceMap map;
        private final int priority;
        private final Iterable<String> pathRoot;
        private Thread creatorThread;

        public ScanRunner(URL classpath, Iterable<String> pkgs, ClasspathResourceMap map, int priority) {
            this.classpath = classpath;
            this.map = map;
            this.priority = priority;
            this.pathRoot = pkgs;
            this.creatorThread = Thread.currentThread();
        }

        @Override
        public void run() {
            block12: {
                boolean jarFile;
                boolean fileUrl;
                Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadsafeUncaughtExceptionHandler(this.creatorThread));
                this.creatorThread = null;
                String path = this.classpath.toExternalForm();
                boolean jarUrl = path.startsWith("jar:");
                if (jarUrl) {
                    path = path.substring("jar:".length());
                }
                if (fileUrl = path.startsWith("file:")) {
                    path = path.substring("file:".length());
                }
                if (jarFile = path.contains(".jar!")) {
                    path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
                } else {
                    jarFile = path.endsWith(".jar");
                }
                File file = new File(path);
                if (!file.exists() && (file = new File(path = new File(path).toURI().toString())).exists()) {
                    throw X_Util.rethrow((Throwable)new FileNotFoundException());
                }
                try {
                    if (this.classpath.getProtocol().equals("jar")) {
                        this.scan(((JarURLConnection)this.classpath.openConnection()).getJarFile());
                        return;
                    }
                    assert (this.classpath.getProtocol().equals("file")) : "ScanRunner only handles url and file protocols";
                    if (jarFile) {
                        this.scan(new JarFile(file));
                        break block12;
                    }
                    String fileRoot = file.getCanonicalPath().replace('\\', '/');
                    int delta = 0;
                    if (!fileRoot.endsWith("/")) {
                        delta = -1;
                        fileRoot = fileRoot + "/";
                    }
                    for (String pkg : this.pathRoot) {
                        if (!fileRoot.replace('/', '.').endsWith(pkg.endsWith(".") ? pkg : pkg + ".")) continue;
                        this.scan(file, fileRoot.substring(0, fileRoot.length() - pkg.length() + delta));
                        break;
                    }
                }
                catch (Exception e) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                }
            }
        }

        private final void scan(File file, String pathRoot) throws IOException {
            if (file.isDirectory()) {
                this.scan(file.listFiles(), pathRoot);
            } else {
                this.addFile(file, pathRoot);
            }
        }

        private void scan(File[] listFiles, String pathRoot) throws IOException {
            for (File file : listFiles) {
                this.scan(file, pathRoot);
            }
        }

        private final void scan(JarFile jarFile) {
            if (ClasspathScannerDefault.this.activeJars.add(jarFile.getName())) {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry next = entries.nextElement();
                    this.addEntry(jarFile, next);
                }
            }
        }

        protected void addFile(File file, String pathRoot) throws IOException {
            String name = file.getCanonicalPath().substring(pathRoot.length());
            if (name.startsWith(File.separator)) {
                name = name.substring(1);
            }
            if (name.endsWith(".class")) {
                if (this.map.includeBytecode(name)) {
                    this.map.addBytecode(name, new ByteCodeResource((ClasspathResource)new FileBackedResource(name, file, this.priority)));
                }
            } else if (name.endsWith(".java")) {
                if (this.map.includeSourcecode(name)) {
                    this.map.addSourcecode(name, new SourceCodeResource((ClasspathResource)new FileBackedResource(name, file, this.priority)));
                }
            } else if (this.map.includeResource(name)) {
                this.map.addResource(name, new StringDataResource((ClasspathResource)new FileBackedResource(name, file, this.priority)));
            }
        }

        protected void addEntry(JarFile file, JarEntry entry) {
            String name = entry.getName();
            for (String pkg : ClasspathScannerDefault.this.pkgs) {
                if (!name.startsWith(pkg)) continue;
                if (name.endsWith(".class")) {
                    if (this.map.includeBytecode(name)) {
                        this.map.addBytecode(name, new ByteCodeResource((ClasspathResource)new JarBackedResource(file, entry, this.priority)));
                    }
                } else if (name.endsWith(".java")) {
                    if (this.map.includeSourcecode(name)) {
                        this.map.addSourcecode(name, new SourceCodeResource((ClasspathResource)new JarBackedResource(file, entry, this.priority)));
                    }
                } else if (this.map.includeResource(name)) {
                    this.map.addResource(name, new StringDataResource((ClasspathResource)new JarBackedResource(file, entry, this.priority)));
                }
                return;
            }
        }
    }
}

