/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner.impl;

import xapi.bytecode.ClassFile;
import xapi.util.api.MatchesValue;

public class MatchesDirectSubclasses
implements MatchesValue<ClassFile> {
    private final String[] subclasses;

    public MatchesDirectSubclasses(String ... subclasses) {
        this.subclasses = subclasses;
    }

    public boolean matches(ClassFile value) {
        if (value.isInterface()) {
            for (String iface : value.getInterfaces()) {
                for (String subclass : this.subclasses) {
                    if (!iface.equals(subclass)) continue;
                    return true;
                }
            }
        } else {
            for (String subclass : this.subclasses) {
                if (!value.getSuperclass().equals(subclass)) continue;
                return true;
            }
        }
        return false;
    }
}

