/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner.impl;

import java.util.ArrayList;
import java.util.List;
import xapi.bytecode.ClassFile;
import xapi.collect.api.PrefixedMap;
import xapi.dev.resource.impl.ByteCodeResource;
import xapi.log.X_Log;
import xapi.util.api.MatchesValue;

public class MatchesImplementationsOf
implements MatchesValue<ClassFile> {
    private final PrefixedMap<ByteCodeResource> bytecode;
    private final List<String> interfaces;
    private final List<String> classes;

    public MatchesImplementationsOf(PrefixedMap<ByteCodeResource> bytecode, String ... subclasses) {
        this.bytecode = bytecode;
        this.interfaces = new ArrayList<String>();
        this.classes = new ArrayList<String>();
        for (String subclass : subclasses) {
            ByteCodeResource resource = (ByteCodeResource)((Object)bytecode.get(subclass));
            if (resource == null) {
                X_Log.warn((Object[])new Object[]{this.getClass(), "Searching for implementations of", subclass, "that are not on search classpath"});
                this.interfaces.add(subclass);
                this.classes.add(subclass);
                continue;
            }
            ClassFile cls = ((ByteCodeResource)((Object)bytecode.get(subclass))).getClassData();
            (cls.isInterface() ? this.interfaces : this.classes).add(subclass);
        }
    }

    public boolean matches(ClassFile value) {
        for (String iface : value.getInterfaces()) {
            for (String subclass : this.interfaces) {
                if (!iface.equals(subclass)) continue;
                return true;
            }
        }
        if (!value.isInterface()) {
            for (String superclass : this.getHierarchy(value)) {
                for (String subclass : this.classes) {
                    if (!superclass.equals(subclass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Iterable<String> getHierarchy(ClassFile value) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        this.addSuperclasses(hierarchy, value.getSuperclass(), value);
        return hierarchy;
    }

    private void addSuperclasses(List<String> hierarchy, String superclass, ClassFile clazz) {
        if (superclass != null) {
            hierarchy.add(superclass);
            if (superclass.equals("java.lang.Object")) {
                return;
            }
            ByteCodeResource resource = (ByteCodeResource)((Object)this.bytecode.get(superclass));
            if (resource == null) {
                X_Log.trace((Object[])new Object[]{this.getClass(), "Unable to find superclass", superclass, "of", clazz, "on classpath; supertype search will end"});
            } else {
                ClassFile cls = resource.getClassData();
                this.addSuperclasses(hierarchy, cls.getSuperclass(), cls);
            }
        }
    }
}

