/*
 * Decompiled with CFR 0.152.
 */
package xapi.collect.impl;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.Consumer;
import xapi.collect.impl.AbstractLinkedList;

public class SimpleLinkedList<T>
extends AbstractLinkedList<T, LinkedListNode<T>, SimpleLinkedList<T>> {
    public void forEachReverse(Consumer<T> consumer) {
        assert (consumer != null);
        Iterator<T> reverse = this.iteratorReverse();
        while (reverse.hasNext()) {
            consumer.accept(reverse.next());
        }
    }

    public Iterator<T> iteratorReverse() {
        return new NodeIteratorReverse();
    }

    public ListIterator<T> listIterator() {
        return new ListIter((LinkedListNode)this.head, 0);
    }

    @Override
    protected LinkedListNode<T> newNode(T item) {
        return new LinkedListNode();
    }

    @Override
    protected void onAdd(LinkedListNode<T> previous, LinkedListNode<T> next) {
        next.previous = previous;
    }

    protected final class NodeIteratorReverse
    implements Iterator<T> {
        private LinkedListNode<T> next;

        protected NodeIteratorReverse() {
            this.next = (LinkedListNode)SimpleLinkedList.this.tail;
        }

        @Override
        public boolean hasNext() {
            return this.next != SimpleLinkedList.this.head;
        }

        @Override
        public T next() {
            try {
                Object object = this.next.value;
                return object;
            }
            finally {
                this.next = this.next.previous;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected final class ListIter
    implements ListIterator<T> {
        private LinkedListNode<T> node;
        int pos;

        public ListIter(LinkedListNode<T> start, int pos) {
            this.node = start;
            this.pos = pos;
        }

        @Override
        public void add(T e) {
            AbstractLinkedList.Node newNode = SimpleLinkedList.this.newNode(e);
            ((LinkedListNode)newNode).value = e;
            ((LinkedListNode)newNode).next = this.node.next;
            ((LinkedListNode)newNode).previous = this.node;
            if (this.node.next == null) {
                SimpleLinkedList.this.tail = newNode;
            } else {
                ((LinkedListNode)this.node.next).previous = newNode;
            }
            this.node.next = newNode;
            SimpleLinkedList.this.onAdd(this.node, newNode);
            this.node = newNode;
        }

        @Override
        public boolean hasNext() {
            return this.node != null && this.node.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.node == null ? SimpleLinkedList.this.tail != null : this.node.previous != null;
        }

        @Override
        public T next() {
            try {
                Object object = ((LinkedListNode)this.node.next).value;
                return object;
            }
            finally {
                ++this.pos;
                this.node = (LinkedListNode)this.node.next;
            }
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public T previous() {
            Object object;
            try {
                object = this.node == null ? ((LinkedListNode)SimpleLinkedList.this.tail).value : this.node.value;
                --this.pos;
                this.node = this.node == null ? ((LinkedListNode)SimpleLinkedList.this.tail).previous : (this.node.previous == null ? (LinkedListNode)SimpleLinkedList.this.head : this.node.previous);
            }
            catch (Throwable throwable) {
                --this.pos;
                this.node = this.node == null ? ((LinkedListNode)SimpleLinkedList.this.tail).previous : (this.node.previous == null ? (LinkedListNode)SimpleLinkedList.this.head : this.node.previous);
                throw throwable;
            }
            return object;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void remove() {
            LinkedListNode next = (LinkedListNode)this.node.next;
            this.node.next = next.next;
            if (next.next == null) {
                SimpleLinkedList.this.tail = this.node;
            } else {
                ((LinkedListNode)next.next).previous = this.node;
            }
            this.node = next;
        }

        @Override
        public void set(T e) {
            this.node.value = e;
        }
    }

    protected static class LinkedListNode<T>
    extends AbstractLinkedList.Node<T, LinkedListNode<T>> {
        LinkedListNode<T> previous;

        protected LinkedListNode() {
        }
    }
}

