/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.source;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import xapi.dev.source.PrintBuffer;
import xapi.source.read.JavaLexer;

public abstract class MemberBuffer<Self extends MemberBuffer<Self>>
extends PrintBuffer {
    protected final Set<String> annotations;
    protected final Set<String> generics;
    protected final String origIndent;
    protected PrintBuffer javaDoc;
    protected int modifier = 1;

    public MemberBuffer() {
        this("");
    }

    public MemberBuffer(String indent) {
        this.indent = indent;
        this.origIndent = indent;
        this.annotations = new TreeSet<String>();
        this.generics = new TreeSet<String>();
    }

    private final Self self() {
        return (Self)this;
    }

    public final Self addGenerics(String ... generics) {
        for (String generic : generics) {
            boolean noImport = (generic = generic.trim()).contains("!");
            if (noImport) {
                this.generics.add(generic.replace("!", ""));
                continue;
            }
            for (String part : generic.split(" ")) {
                String shortened;
                int index = generic.lastIndexOf(".");
                if (index <= 0 || (shortened = this.addImport(part)).length() == part.trim().length()) continue;
                generic = generic.replace(part.substring(0, part.length() - shortened.length()), "");
            }
            this.generics.add(generic);
        }
        return this.self();
    }

    public abstract String addImport(String var1);

    public abstract String addImport(Class<?> var1);

    public abstract String addImportStatic(String var1);

    public abstract String addImportStatic(Class<?> var1, String var2);

    public final Self addImports(String ... clses) {
        for (String cls : clses) {
            this.addImport(cls);
        }
        return this.self();
    }

    public final Self addImports(Class<?> ... clses) {
        for (Class<?> cls : clses) {
            this.addImport(cls);
        }
        return this.self();
    }

    public final Self addAnnotation(Class<?> anno) {
        this.annotations.add(this.addImport(anno));
        return this.self();
    }

    public final Self addAnnotation(String anno) {
        int openParen;
        if (anno.charAt(0) == '@') {
            anno = anno.substring(1);
        }
        if ((openParen = (anno = anno.trim()).indexOf(40)) == -1) {
            int hasPeriod = anno.lastIndexOf(46);
            if (hasPeriod != -1) {
                anno = this.addImport(anno);
            }
        } else {
            int hasPeriod = anno.lastIndexOf(46, openParen);
            if (hasPeriod != -1) {
                String annoName = this.addImport(anno.substring(0, openParen));
                anno = annoName + anno.substring(openParen);
            }
        }
        this.annotations.add(anno);
        return this.self();
    }

    protected final PrintBuffer createJavadoc() {
        if (this.javaDoc == null) {
            this.javaDoc = new PrintBuffer();
        }
        return this.javaDoc;
    }

    public final Self setJavadoc(String doc) {
        String[] bits = doc.split("\n");
        if (bits.length > 0) {
            this.javaDoc = new PrintBuffer();
            this.javaDoc.indent = this.origIndent;
            if (bits.length == 1) {
                this.javaDoc.println("/** " + doc + " */");
            } else {
                this.javaDoc.println("/**");
                for (String bit : bits) {
                    this.javaDoc.print("* ");
                    if ("".equals(bit)) {
                        this.javaDoc.println("<br/>");
                        continue;
                    }
                    this.javaDoc.println(bit);
                }
                this.javaDoc.println("*/");
            }
        }
        return this.self();
    }

    public final Self makeFinal() {
        if ((this.modifier & 0x400) > 0) {
            this.modifier &= 0xFFFFFBFF;
        }
        this.modifier |= 0x10;
        return this.self();
    }

    protected Self makeAbstract() {
        if ((this.modifier & 0x10) > 0) {
            this.modifier &= 0xFFFFFFEF;
        }
        if ((this.modifier & 8) > 0) {
            this.modifier &= 0xFFFFFFF7;
        }
        this.modifier |= 0x400;
        return this.self();
    }

    public final Self makeStatic() {
        if ((this.modifier & 0x400) > 0) {
            this.modifier &= 0xFFFFFBFF;
        }
        this.modifier |= 8;
        return this.self();
    }

    public final Self makeConcrete() {
        this.modifier &= 0xFFFFFBFF;
        return this.self();
    }

    public final Self makePublic() {
        this.modifier = (this.modifier & 0xFFF8) + 1;
        return this.self();
    }

    public final Self makeProtected() {
        this.modifier = (this.modifier & 0xFFF8) + 4;
        return this.self();
    }

    public final Self makePrivate() {
        this.modifier = (this.modifier & 0xFFF8) + 2;
        return this.self();
    }

    public final Self makePackageProtected() {
        this.modifier &= 0xFFF8;
        return this.self();
    }

    public boolean isStatic() {
        return (this.modifier & 8) > 0;
    }

    public boolean isFinal() {
        return (this.modifier & 0x10) > 0;
    }

    protected boolean isAbstract() {
        return (this.modifier & 0x400) > 0;
    }

    public Self setModifier(int modifier) {
        if ((modifier & 7) > 0) {
            switch (modifier & 7) {
                case 1: {
                    this.makePublic();
                    break;
                }
                case 2: {
                    this.makePrivate();
                    break;
                }
                case 4: {
                    this.makeProtected();
                }
            }
        }
        this.modifier |= modifier;
        return this.self();
    }

    public final Self append(boolean b) {
        super.append(b);
        return this.self();
    }

    public final Self append(char c) {
        super.append(c);
        return this.self();
    }

    public final Self append(char[] str) {
        super.append(str);
        return this.self();
    }

    public final Self append(char[] str, int offset, int len) {
        super.append(str, offset, len);
        return this.self();
    }

    public final Self append(CharSequence s) {
        super.append(s);
        return this.self();
    }

    public final Self append(CharSequence s, int start, int end) {
        super.append(s, start, end);
        return this.self();
    }

    public final Self append(double d) {
        super.append(d);
        return this.self();
    }

    public final Self append(float f) {
        super.append(f);
        return this.self();
    }

    public final Self append(int i) {
        super.append(i);
        return this.self();
    }

    public final Self append(long lng) {
        super.append(lng);
        return this.self();
    }

    public final Self append(Object obj) {
        super.append(obj);
        return this.self();
    }

    public final Self append(String str) {
        super.append(str);
        return this.self();
    }

    public final Self indent() {
        super.indent();
        return this.self();
    }

    public final Self indentln(char[] str) {
        super.indentln(str);
        return this.self();
    }

    public final Self indentln(CharSequence s) {
        super.indentln(s);
        return this.self();
    }

    public final Self indentln(Object obj) {
        super.indentln(obj);
        return this.self();
    }

    public final Self indentln(String str) {
        super.indentln(str);
        return this.self();
    }

    public final Self outdent() {
        super.outdent();
        return this.self();
    }

    public final Self println() {
        super.println();
        return this.self();
    }

    public final Self println(char[] str) {
        super.println(str);
        return this.self();
    }

    public final Self println(CharSequence s) {
        super.println(s);
        return this.self();
    }

    public final Self println(Object obj) {
        super.println(obj);
        return this.self();
    }

    public final Self println(String str) {
        super.println(str);
        return this.self();
    }

    public Self print(String str) {
        super.print(str);
        return this.self();
    }

    protected void addNamedTypes(Set<String> result, Iterable<Map.Entry<String, Class<?>>> types) {
        for (Map.Entry<String, Class<?>> type : types) {
            String shortName = this.addImport(type.getValue());
            result.add(shortName + " " + type.getKey());
        }
    }

    protected void addNamedTypes(Set<String> result, String ... types) {
        for (String parameter : types) {
            parameter = parameter.trim();
            int index = parameter.lastIndexOf(32);
            assert (index > 0) : "Malformed named parameter missing ' ': " + parameter + "; from " + Arrays.asList(types);
            JavaLexer.TypeDef type = JavaLexer.extractType(parameter, 0);
            String shortName = this.addImport(type.getImportName());
            result.add(shortName + " " + parameter.substring(index + 1).trim());
        }
    }

    protected void addTypes(Set<String> result, Class<?> ... types) {
        for (Class<?> type : types) {
            result.add(this.addImport(type.getCanonicalName()));
        }
    }

    protected void addTypes(Set<String> result, String ... types) {
        for (String typeName : types) {
            typeName = typeName.trim();
            JavaLexer.TypeDef type = JavaLexer.extractType(typeName, 0);
            if (type.pkgName.length() > 0) {
                String shortName = this.addImport(type.getImportName());
                result.add(shortName);
            }
            result.add(typeName);
        }
    }
}

