/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import xapi.bytecode.ClassFile;
import xapi.bytecode.ClassMap;
import xapi.bytecode.ClassPool;
import xapi.bytecode.CtMethod;
import xapi.bytecode.CtPrimitiveType;
import xapi.bytecode.NotFoundException;

public abstract class CtClass {
    protected String qualifiedName;
    static final String javaLangObject = "java.lang.Object";
    public static CtClass booleanType;
    public static CtClass charType;
    public static CtClass byteType;
    public static CtClass shortType;
    public static CtClass intType;
    public static CtClass longType;
    public static CtClass floatType;
    public static CtClass doubleType;
    public static CtClass voidType;
    static CtClass[] primitiveTypes;

    protected CtClass(String name) {
        this.qualifiedName = name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append("@");
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append("[");
        this.extendToString(buf);
        buf.append("]");
        return buf.toString();
    }

    protected void extendToString(StringBuffer buffer) {
        buffer.append(this.getName());
    }

    public ClassPool getClassPool() {
        return null;
    }

    public ClassFile getClassFile() {
        this.checkModify();
        return this.getClassFile2();
    }

    public ClassFile getClassFile2() {
        return null;
    }

    public URL getURL() throws NotFoundException {
        throw new NotFoundException(this.getName());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isFrozen() {
        return true;
    }

    public void freeze() {
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            throw new RuntimeException(this.getName() + " class is frozen");
        }
    }

    public void defrost() {
        throw new RuntimeException("cannot defrost " + this.getName());
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public CtClass getComponentType() throws NotFoundException {
        return null;
    }

    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        return this == clazz || this.getName().equals(clazz.getName());
    }

    public String getName() {
        return this.qualifiedName;
    }

    public final String getSimpleName() {
        String qname = this.qualifiedName;
        int index = qname.lastIndexOf(46);
        if (index < 0) {
            return qname;
        }
        return qname.substring(index + 1);
    }

    public final String getPackageName() {
        String qname = this.qualifiedName;
        int index = qname.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return qname.substring(0, index);
    }

    public void setName(String name) {
        this.checkModify();
        if (name != null) {
            this.qualifiedName = name;
        }
    }

    public void replaceClassName(String oldName, String newName) {
        this.checkModify();
    }

    public void replaceClassName(ClassMap map) {
        this.checkModify();
    }

    public synchronized Collection<?> getRefClasses() {
        ClassFile cf = this.getClassFile2();
        if (cf != null) {
            ClassMap cm = new ClassMap(){
                private static final long serialVersionUID = -5711248080014397497L;

                @Override
                public void put(String oldname, String newname) {
                    this.put0(oldname, newname);
                }

                @Override
                public Object get(Object jvmClassName) {
                    String n = 1.toJavaName((String)jvmClassName);
                    this.put0(n, n);
                    return null;
                }

                @Override
                public void fix(String name) {
                }
            };
            cf.renameClass(cm);
            return cm.values();
        }
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public int getModifiers() {
        return 0;
    }

    public boolean hasAnnotation(Class<?> clz) {
        return false;
    }

    public Object getAnnotation(Class<?> clz) throws ClassNotFoundException {
        return null;
    }

    public Object[] getAnnotations() throws ClassNotFoundException {
        return new Object[0];
    }

    public Object[] getAvailableAnnotations() {
        return new Object[0];
    }

    public CtClass[] getNestedClasses() throws NotFoundException {
        return new CtClass[0];
    }

    public void setModifiers(int mod) {
        this.checkModify();
    }

    public boolean subclassOf(CtClass superclass) {
        return false;
    }

    public CtClass getSuperclass() throws NotFoundException {
        return null;
    }

    public void setSuperclass(CtClass clazz) {
        this.checkModify();
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        return new CtClass[0];
    }

    public void setInterfaces(CtClass[] list) {
        this.checkModify();
    }

    public void addInterface(CtClass anInterface) {
        this.checkModify();
    }

    public CtClass getDeclaringClass() throws NotFoundException {
        return null;
    }

    public CtClass makeNestedClass(String name, boolean isStatic) {
        throw new RuntimeException(this.getName() + " is not a class");
    }

    public CtMethod[] getMethods() {
        return new CtMethod[0];
    }

    public CtMethod getMethod(String name, String desc) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public CtMethod[] getDeclaredMethods() {
        return new CtMethod[0];
    }

    public CtMethod getDeclaredMethod(String name, CtClass[] params) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public CtMethod getDeclaredMethod(String name) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public byte[] getAttribute(String name) {
        return null;
    }

    public void setAttribute(String name, byte[] data) {
        this.checkModify();
    }

    public void detach() {
        ClassPool cp = this.getClassPool();
        CtClass obj = cp.removeCached(this.getName());
        if (obj != this) {
            cp.cacheCtClass(this.getName(), obj, false);
        }
    }

    public boolean stopPruning(boolean stop) {
        return true;
    }

    public void prune() {
    }

    void incGetCounter() {
    }

    public void rebuildClassFile() {
    }

    public String makeUniqueName(String prefix) {
        throw new RuntimeException("not available in " + this.getName());
    }

    void compress() {
    }

    static {
        primitiveTypes = new CtClass[9];
        CtClass.primitiveTypes[0] = booleanType = new CtPrimitiveType("boolean", 'Z', "java.lang.Boolean", "booleanValue", "()Z", 1);
        CtClass.primitiveTypes[1] = charType = new CtPrimitiveType("char", 'C', "java.lang.Character", "charValue", "()C", 1);
        CtClass.primitiveTypes[2] = byteType = new CtPrimitiveType("byte", 'B', "java.lang.Byte", "byteValue", "()B", 1);
        CtClass.primitiveTypes[3] = shortType = new CtPrimitiveType("short", 'S', "java.lang.Short", "shortValue", "()S", 1);
        CtClass.primitiveTypes[4] = intType = new CtPrimitiveType("int", 'I', "java.lang.Integer", "intValue", "()I", 1);
        CtClass.primitiveTypes[5] = longType = new CtPrimitiveType("long", 'J', "java.lang.Long", "longValue", "()J", 2);
        CtClass.primitiveTypes[6] = floatType = new CtPrimitiveType("float", 'F', "java.lang.Float", "floatValue", "()F", 1);
        CtClass.primitiveTypes[7] = doubleType = new CtPrimitiveType("double", 'D', "java.lang.Double", "doubleValue", "()D", 2);
        CtClass.primitiveTypes[8] = voidType = new CtPrimitiveType("void", 'V', "java.lang.Void", null, null, 0);
    }

    static class DelayedFileOutputStream
    extends OutputStream {
        private FileOutputStream file = null;
        private String filename;

        DelayedFileOutputStream(String name) {
            this.filename = name;
        }

        private void init() throws IOException {
            if (this.file == null) {
                this.file = new FileOutputStream(this.filename);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.init();
            this.file.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.init();
            this.file.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.init();
            this.file.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.init();
            this.file.flush();
        }

        @Override
        public void close() throws IOException {
            this.init();
            this.file.close();
        }
    }
}

