/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;

class LongInfo
extends ConstInfo {
    static final int tag = 5;
    long value;

    public LongInfo(long l) {
        this.value = l;
    }

    public LongInfo(DataInput in) throws IOException {
        this.value = in.readLong();
    }

    @Override
    public int getTag() {
        return 5;
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        return dest.addLongInfo(this.value);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(5);
        out.writeLong(this.value);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("Long ");
        out.println(this.value);
    }
}

