/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;

class StringInfo
extends ConstInfo {
    static final int tag = 8;
    int string;

    public StringInfo(int str) {
        this.string = str;
    }

    public StringInfo(DataInput in) throws IOException {
        this.string = in.readUnsignedShort();
    }

    @Override
    public int getTag() {
        return 8;
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        return dest.addStringInfo(src.getUtf8Info(this.string));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(8);
        out.writeShort(this.string);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("String #");
        out.println(this.string);
    }
}

