/*
 * Decompiled with CFR 0.152.
 */
package xapi.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import xapi.bytecode.ConstInfo;
import xapi.bytecode.ConstPool;

class Utf8Info
extends ConstInfo {
    static final int tag = 1;
    String string;
    int index;

    public Utf8Info(String utf8, int i) {
        this.string = utf8;
        this.index = i;
    }

    public Utf8Info(DataInput in, int i) throws IOException {
        this.string = in.readUTF();
        this.index = i;
    }

    @Override
    public int getTag() {
        return 1;
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<?, ?> map) {
        return dest.addUtf8Info(this.string);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        out.writeUTF(this.string);
    }

    @Override
    public void print(PrintWriter out) {
        out.print("UTF8 \"");
        out.print(this.string);
        out.println("\"");
    }
}

