/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import xapi.bytecode.ClassFile;
import xapi.dev.scanner.ByteCodeResource;
import xapi.dev.scanner.ResourceTrie;
import xapi.dev.scanner.SourceCodeResource;
import xapi.dev.scanner.StringDataResource;
import xapi.util.api.Pointer;

public class ClasspathResourceMap {
    private final ResourceTrie<ByteCodeResource> bytecode;
    private final ResourceTrie<SourceCodeResource> sources;
    private final ResourceTrie<StringDataResource> resources;
    private final Set<Class<? extends Annotation>> annotations;
    private final Set<Pattern> bytecodeMatchers;
    private final ExecutorService executor;
    private final Set<Pattern> resourceMatchers;
    private final Set<Pattern> sourceMatchers;
    private final Queue<Future<?>> pending;

    public ClasspathResourceMap(ExecutorService executor, Set<Class<? extends Annotation>> annotations, Set<Pattern> bytecodeMatchers, Set<Pattern> resourceMatchers, Set<Pattern> sourceMatchers) {
        this.annotations = annotations;
        this.bytecodeMatchers = bytecodeMatchers;
        this.executor = executor;
        this.resourceMatchers = resourceMatchers;
        this.sourceMatchers = sourceMatchers;
        this.bytecode = new ResourceTrie();
        this.sources = new ResourceTrie();
        this.resources = new ResourceTrie();
        this.pending = new ConcurrentLinkedQueue();
    }

    public void addBytecode(final String name, final ByteCodeResource bytecode) {
        if (this.annotations.size() == 0) {
            this.bytecode.put(name, bytecode);
        } else {
            final Pointer future = new Pointer();
            future.set(this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ClasspathResourceMap.this.accept(name, bytecode, ClasspathResourceMap.this.annotations);
                    }
                    finally {
                        ClasspathResourceMap.this.pending.remove(future.remove());
                    }
                }
            }));
            this.pending.add((Future<?>)future.get());
        }
    }

    protected void accept(String name, ByteCodeResource bytecode, Set<Class<? extends Annotation>> annotations) {
        ClassFile classFile = bytecode.getClassData();
        for (Class<? extends Annotation> cls : annotations) {
            if (classFile.getAnnotation(cls.getName()) == null) continue;
            this.bytecode.put(name, bytecode);
            return;
        }
    }

    public void addSourcecode(String name, SourceCodeResource sourcecode) {
        this.sources.put(name, sourcecode);
    }

    public void addResource(String name, StringDataResource resource) {
        this.resources.put(name, resource);
    }

    public boolean includeResource(String name) {
        for (Pattern p : this.resourceMatchers) {
            if (p.matcher(name).matches()) {
                return true;
            }
            if (!p.matcher(name.substring(name.lastIndexOf(47) + 1)).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean includeSourcecode(String name) {
        for (Pattern p : this.sourceMatchers) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean includeBytecode(String name) {
        for (Pattern p : this.bytecodeMatchers) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public final Iterable<StringDataResource> findResources(final String prefix, final Pattern ... patterns) {
        this.flush();
        if (patterns.length == 0) {
            return this.resources.findPrefixed(prefix);
        }
        return new Iterable<StringDataResource>(){

            @Override
            public Iterator<StringDataResource> iterator() {
                class Itr
                implements Iterator<StringDataResource> {
                    StringDataResource cls;
                    Iterator<StringDataResource> iter;
                    final /* synthetic */ String val$prefix;
                    final /* synthetic */ Pattern[] val$patterns;

                    Itr() {
                        this.val$prefix = string;
                        this.val$patterns = patternArray;
                        this.iter = ClasspathResourceMap.this.resources.findPrefixed(this.val$prefix).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next();
                            for (Pattern pattern : this.val$patterns) {
                                if (!pattern.matcher(this.cls.getResourceName()).matches()) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    public StringDataResource next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, prefix, patterns);
            }
        };
    }

    public final Iterable<ClassFile> findClassAnnotatedWith(final Class<? extends Annotation> ... annotations) {
        this.flush();
        return new Iterable<ClassFile>(){

            @Override
            public Iterator<ClassFile> iterator() {
                class Itr
                implements Iterator<ClassFile> {
                    ClassFile cls;
                    Iterator<ByteCodeResource> iter;
                    final /* synthetic */ Class[] val$annotations;

                    Itr() {
                        this.val$annotations = classArray;
                        this.iter = ClasspathResourceMap.this.bytecode.findPrefixed("").iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.iter.hasNext()) {
                            this.cls = this.iter.next().getClassData();
                            for (Class annotation : this.val$annotations) {
                                if (this.cls.getAnnotation(annotation.getName()) == null) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    public ClassFile next() {
                        return this.cls;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Itr(ClasspathResourceMap.this, annotations);
            }
        };
    }

    private void flush() {
        if (this.pending.isEmpty()) {
            return;
        }
        long deadline = System.currentTimeMillis() + 10000L;
        while (deadline > System.currentTimeMillis() && !this.pending.isEmpty()) {
            Iterator iter = this.pending.iterator();
            while (iter.hasNext()) {
                if (!((Future)iter.next()).isDone()) continue;
                iter.remove();
            }
            try {
                Thread.sleep(0L, 100);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

