/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.scanner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import xapi.annotation.inject.InstanceDefault;
import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;
import xapi.dev.scanner.ByteCodeResource;
import xapi.dev.scanner.ClasspathResourceMap;
import xapi.dev.scanner.ClasspathScanner;
import xapi.dev.scanner.FileBackedResource;
import xapi.dev.scanner.JarBackedResource;
import xapi.dev.scanner.SourceCodeResource;
import xapi.dev.scanner.StringDataResource;
import xapi.util.X_Debug;

@InstanceDefault(implFor=ClasspathScanner.class)
public class ClasspathScannerDefault
implements ClasspathScanner {
    final Set<String> pkgs = new HashSet<String>();
    final Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
    final Set<Pattern> resourceMatchers = new HashSet<Pattern>();
    final Set<Pattern> bytecodeMatchers = new HashSet<Pattern>();
    final Set<Pattern> sourceMatchers = new HashSet<Pattern>();

    @Override
    public ClasspathScanner scanAnnotation(Class<? extends Annotation> annotation) {
        this.annotations.add(annotation);
        return this;
    }

    @Override
    public ClasspathScanner scanAnnotations(Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            this.annotations.add(annotation);
        }
        return this;
    }

    @Override
    public ClasspathResourceMap scan(ClassLoader loaders) {
        ExecutorService executor = Executors.newFixedThreadPool(7);
        return this.scan(loaders, executor);
    }

    @Override
    public synchronized ClasspathResourceMap scan(ClassLoader loadFrom, ExecutorService executor) {
        LinkedHashMap<URL, Fifo> classPaths = new LinkedHashMap<URL, Fifo>();
        if (this.pkgs.size() == 0) {
            for (String pkg : System.getProperty("xapi.inject.packages", "xapi,META-INF/singletons,META-INF/instances").split(",\\s*")) {
                this.pkgs.add(pkg);
            }
        }
        for (String pkg : this.pkgs) {
            Enumeration<URL> resources;
            try {
                resources = loadFrom.getResources(pkg.equals(".*") ? "." : pkg);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Fifo fifo = (Fifo)classPaths.get(resource);
                if (fifo == null) {
                    fifo = new SimpleFifo();
                    fifo.give((Object)pkg);
                    classPaths.put(resource, fifo);
                    continue;
                }
                fifo.remove((Object)pkg);
                fifo.give((Object)pkg);
            }
        }
        int pos = 0;
        ClasspathResourceMap map = new ClasspathResourceMap(executor, this.annotations, this.bytecodeMatchers, this.resourceMatchers, this.sourceMatchers);
        SimpleFifo jobs = new SimpleFifo();
        for (URL url : classPaths.keySet()) {
            Fifo packages = (Fifo)classPaths.get(url);
            jobs.give(executor.submit(this.newScanRunner(url, map, executor, packages.forEach(), pos)));
        }
        while (!jobs.isEmpty()) {
            Iterator iter = jobs.forEach().iterator();
            while (iter.hasNext()) {
                if (!((Future)iter.next()).isDone()) continue;
                iter.remove();
            }
            try {
                Thread.sleep(0L, 50);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return map;
            }
        }
        return map;
    }

    private Runnable newScanRunner(URL classPath, ClasspathResourceMap map, ExecutorService executor, Iterable<String> pkgs, int priority) {
        return new ScanRunner(classPath, pkgs, map, priority);
    }

    @Override
    public ClasspathScanner scanPackage(String pkg) {
        this.pkgs.add(pkg);
        return this;
    }

    @Override
    public ClasspathScanner scanPackages(String ... pkgs) {
        for (String pkg : pkgs) {
            this.pkgs.add(pkg);
        }
        return this;
    }

    @Override
    public ClasspathScanner matchClassFile(String regex) {
        this.bytecodeMatchers.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ClasspathScanner matchClassFiles(String ... regexes) {
        for (String regex : regexes) {
            this.bytecodeMatchers.add(Pattern.compile(regex));
        }
        return this;
    }

    @Override
    public ClasspathScanner matchResource(String regex) {
        this.resourceMatchers.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ClasspathScanner matchResources(String ... regexes) {
        for (String regex : regexes) {
            this.resourceMatchers.add(Pattern.compile(regex));
        }
        return this;
    }

    @Override
    public ClasspathScanner matchSourceFile(String regex) {
        this.sourceMatchers.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ClasspathScanner matchSourceFiles(String ... regexes) {
        for (String regex : regexes) {
            this.sourceMatchers.add(Pattern.compile(regex));
        }
        return this;
    }

    protected class ScanRunner
    implements Runnable {
        private final URL classpath;
        private final ClasspathResourceMap map;
        private final int priority;
        private final Iterable<String> pathRoot;

        public ScanRunner(URL classpath, Iterable<String> pkgs, ClasspathResourceMap map, int priority) {
            this.classpath = classpath;
            this.map = map;
            this.priority = priority;
            this.pathRoot = pkgs;
        }

        @Override
        public final void run() {
            block10: {
                File file;
                boolean jarFile;
                boolean fileUrl;
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        e.printStackTrace();
                    }
                });
                String path = this.classpath.toExternalForm();
                boolean jarUrl = path.startsWith("jar:");
                if (jarUrl) {
                    path = path.substring("jar:".length());
                }
                if (fileUrl = path.startsWith("file:")) {
                    path = path.substring("file:".length());
                }
                if (jarFile = path.contains(".jar!")) {
                    path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
                }
                if (!(file = new File(path)).exists() && (file = new File(path = path.replace("%20", " "))).exists()) {
                    throw X_Debug.wrap((Throwable)new FileNotFoundException());
                }
                try {
                    if (this.classpath.getProtocol().equals("jar")) {
                        this.scan(((JarURLConnection)this.classpath.openConnection()).getJarFile());
                        return;
                    }
                    assert (this.classpath.getProtocol().equals("file")) : "ScanRunner only handles url and file protocols";
                    if (jarFile) {
                        this.scan(new JarFile(file));
                        break block10;
                    }
                    String fileRoot = file.getCanonicalPath().replace('\\', '/');
                    for (String pkg : this.pathRoot) {
                        if (!fileRoot.endsWith(pkg)) continue;
                        this.scan(file, fileRoot.substring(0, fileRoot.length() - pkg.length()));
                        break;
                    }
                }
                catch (Exception e) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                }
            }
        }

        private final void scan(File file, String pathRoot) throws IOException {
            if (file.isDirectory()) {
                this.scan(file.listFiles(), pathRoot);
            } else {
                this.addFile(file, pathRoot);
            }
        }

        private void scan(File[] listFiles, String pathRoot) throws IOException {
            for (File file : listFiles) {
                this.scan(file, pathRoot);
            }
        }

        private final void scan(JarFile jarFile) {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry next = entries.nextElement();
                this.addEntry(jarFile, next);
            }
        }

        protected void addFile(File file, String pathRoot) throws IOException {
            String name = file.getCanonicalPath().substring(pathRoot.length());
            if (name.endsWith(".class")) {
                if (this.map.includeBytecode(name)) {
                    this.map.addBytecode(name, new ByteCodeResource(new FileBackedResource(name, file, this.priority)));
                }
            } else if (name.endsWith(".java")) {
                if (this.map.includeSourcecode(name)) {
                    this.map.addSourcecode(name, new SourceCodeResource(new FileBackedResource(name, file, this.priority)));
                }
            } else if (this.map.includeResource(name)) {
                this.map.addResource(name, new StringDataResource(new FileBackedResource(name, file, this.priority)));
            }
        }

        protected void addEntry(JarFile file, JarEntry entry) {
            String name = entry.getName();
            for (String pkg : ClasspathScannerDefault.this.pkgs) {
                if (!name.startsWith(pkg)) continue;
                if (name.endsWith(".class")) {
                    if (this.map.includeBytecode(name)) {
                        this.map.addBytecode(name, new ByteCodeResource(new JarBackedResource(file, entry, this.priority)));
                    }
                } else if (name.endsWith(".java")) {
                    if (this.map.includeSourcecode(name)) {
                        this.map.addSourcecode(name, new SourceCodeResource(new JarBackedResource(file, entry, this.priority)));
                    }
                } else if (this.map.includeResource(name)) {
                    this.map.addResource(name, new StringDataResource(new JarBackedResource(file, entry, this.priority)));
                }
                return;
            }
        }
    }
}

