package xapi.annotation.compile;


import xapi.annotation.compile.Dependency;

@SuppressWarnings("all")
public class DependencyBuilder {

  private static final class ImmutableDependency implements Dependency {

    private final String value;

    private final String groupId;

    private final String version;

    private final String classifier;

    private final Dependency.DependencyType dependencyType;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.compile.Dependency.class;
    }

    public final String value () {
      return value;
    }

    public final String groupId () {
      return groupId;
    }

    public final String version () {
      return version;
    }

    public final String classifier () {
      return classifier;
    }

    public final Dependency.DependencyType dependencyType () {
      return dependencyType;
    }

    private ImmutableDependency  (String value, String groupId, String version, String classifier, Dependency.DependencyType dependencyType) {
      this.value = value;
      this.groupId = groupId;
      this.version = version;
      this.classifier = classifier;
      this.dependencyType = dependencyType;
    }

  }

  public static DependencyBuilder buildDependency (String value) {
    return new DependencyBuilder(value);
  }

  private String value;

  private String groupId;

  private String version;

  private String classifier;

  private Dependency.DependencyType dependencyType;

  public final String getValue () {
    return value;
  }

  public final DependencyBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  public final String getGroupId () {
    return groupId;
  }

  public final DependencyBuilder setGroupId (String groupId) {
    this.groupId = groupId;
    return this;
  }

  public final String getVersion () {
    return version;
  }

  public final DependencyBuilder setVersion (String version) {
    this.version = version;
    return this;
  }

  public final String getClassifier () {
    return classifier;
  }

  public final DependencyBuilder setClassifier (String classifier) {
    this.classifier = classifier;
    return this;
  }

  public final Dependency.DependencyType getDependencyType () {
    return dependencyType;
  }

  public final DependencyBuilder setDependencyType (Dependency.DependencyType dependencyType) {
    this.dependencyType = dependencyType;
    return this;
  }

  private DependencyBuilder  (String value) {
    this.value = value;
  }

  public Dependency build () {
    return new ImmutableDependency(value, groupId, version, classifier, dependencyType);
  }

}
