package xapi.annotation.compile;


import xapi.annotation.compile.Resource;

@SuppressWarnings("all")
public class ResourceBuilder {

  private static final class ImmutableResource implements Resource {

    private final String value;

    private final Resource.ResourceType type;

    private final String qualifier;

    private final boolean required;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.compile.Resource.class;
    }

    public final String value () {
      return value;
    }

    public final Resource.ResourceType type () {
      return type;
    }

    public final String qualifier () {
      return qualifier;
    }

    public final boolean required () {
      return required;
    }

    private ImmutableResource  (String value, Resource.ResourceType type, String qualifier, boolean required) {
      this.value = value;
      this.type = type;
      this.qualifier = qualifier;
      this.required = required;
    }

  }

  public static ResourceBuilder buildResource (String value) {
    return new ResourceBuilder(value);
  }

  private String value;

  private Resource.ResourceType type;

  private String qualifier;

  private boolean required;

  public final String getValue () {
    return value;
  }

  public final ResourceBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  public final Resource.ResourceType getType () {
    return type;
  }

  public final ResourceBuilder setType (Resource.ResourceType type) {
    this.type = type;
    return this;
  }

  public final String getQualifier () {
    return qualifier;
  }

  public final ResourceBuilder setQualifier (String qualifier) {
    this.qualifier = qualifier;
    return this;
  }

  public final boolean isRequired () {
    return required;
  }

  public final ResourceBuilder setRequired (boolean required) {
    this.required = required;
    return this;
  }

  private ResourceBuilder  (String value) {
    this.value = value;
  }

  public Resource build () {
    return new ImmutableResource(value, type, qualifier, required);
  }

}
