package xapi.annotation.inject;

import xapi.annotation.inject.InstanceOverride;

@SuppressWarnings("all")
public class InstanceOverrideBuilder {

  private static final class ImmutableInstanceOverride implements InstanceOverride {

    private final Class<?> implFor;

    private final int priority;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.inject.InstanceOverride.class;
    }

    public final Class<?> implFor () {
      return implFor;
    }

    public final int priority () {
      return priority;
    }

    private ImmutableInstanceOverride  (Class<?> implFor, int priority) {
      this.implFor = implFor;
      this.priority = priority;
    }

  }

  public static InstanceOverrideBuilder buildInstanceOverride (Class<?> implFor) {
    return new InstanceOverrideBuilder(implFor);
  }

  private Class<?> implFor;

  private int priority;

  public final Class<?> getImplFor () {
    return implFor;
  }

  public final InstanceOverrideBuilder setImplFor (Class<?> implFor) {
    this.implFor = implFor;
    return this;
  }

  public final int getPriority () {
    return priority;
  }

  public final InstanceOverrideBuilder setPriority (int priority) {
    this.priority = priority;
    return this;
  }

  private InstanceOverrideBuilder  (Class<?> implFor) {
    this.implFor = implFor;
  }

  public InstanceOverride build () {
    return new ImmutableInstanceOverride(implFor, priority);
  }

}
