package xapi.annotation.inject;

import xapi.annotation.inject.SingletonOverride;

@SuppressWarnings("all")
public class SingletonOverrideBuilder {

  private static final class ImmutableSingletonOverride implements SingletonOverride {

    private final Class<?> implFor;

    private final int priority;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.inject.SingletonOverride.class;
    }

    public final Class<?> implFor () {
      return implFor;
    }

    public final int priority () {
      return priority;
    }

    private ImmutableSingletonOverride  (Class<?> implFor, int priority) {
      this.implFor = implFor;
      this.priority = priority;
    }

  }

  public static SingletonOverrideBuilder buildSingletonOverride (Class<?> implFor) {
    return new SingletonOverrideBuilder(implFor);
  }

  private Class<?> implFor;

  private int priority;

  public final Class<?> getImplFor () {
    return implFor;
  }

  public final SingletonOverrideBuilder setImplFor (Class<?> implFor) {
    this.implFor = implFor;
    return this;
  }

  public final int getPriority () {
    return priority;
  }

  public final SingletonOverrideBuilder setPriority (int priority) {
    this.priority = priority;
    return this;
  }

  private SingletonOverrideBuilder  (Class<?> implFor) {
    this.implFor = implFor;
  }

  public SingletonOverride build () {
    return new ImmutableSingletonOverride(implFor, priority);
  }

}
