package xapi.annotation.model;

import xapi.annotation.model.AdderFor;

@SuppressWarnings("all")
public class AdderForBuilder {

  private static final class ImmutableAdderFor implements AdderFor {

    private final String value;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.AdderFor.class;
    }

    public final String value () {
      return value;
    }

    private ImmutableAdderFor  (String value) {
      this.value = value;
    }

  }

  public static AdderForBuilder buildAdderFor (String value) {
    return new AdderForBuilder(value);
  }

  private String value;

  public final String getValue () {
    return value;
  }

  public final AdderForBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  private AdderForBuilder  (String value) {
    this.value = value;
  }

  public AdderFor build () {
    return new ImmutableAdderFor(value);
  }

}
