package xapi.annotation.model;


import xapi.annotation.model.ClientToServer;

@SuppressWarnings("all")
public class ClientToServerBuilder {

  private static final class ImmutableClientToServer implements ClientToServer {

    private final SerializationStrategy serializer;

    private final boolean enabled;

    private final boolean encrypted;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.ClientToServer.class;
    }

    public final SerializationStrategy serializer () {
      return serializer;
    }

    public final boolean enabled () {
      return enabled;
    }

    public final boolean encrypted () {
      return encrypted;
    }

    private ImmutableClientToServer  (SerializationStrategy serializer, boolean enabled, boolean encrypted) {
      this.serializer = serializer;
      this.enabled = enabled;
      this.encrypted = encrypted;
    }

  }

  public static ClientToServerBuilder buildClientToServer () {
    return new ClientToServerBuilder();
  }

  private SerializationStrategy serializer;

  private boolean enabled;

  private boolean encrypted;

  public final SerializationStrategy getSerializer () {
    return serializer;
  }

  public final ClientToServerBuilder setSerializer (SerializationStrategy serializer) {
    this.serializer = serializer;
    return this;
  }

  public final boolean isEnabled () {
    return enabled;
  }

  public final ClientToServerBuilder setEnabled (boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  public final boolean isEncrypted () {
    return encrypted;
  }

  public final ClientToServerBuilder setEncrypted (boolean encrypted) {
    this.encrypted = encrypted;
    return this;
  }

  private ClientToServerBuilder  () {
  }

  public ClientToServer build () {
    return new ImmutableClientToServer(serializer, enabled, encrypted);
  }

}
