package xapi.annotation.model;

import xapi.annotation.model.DeleterFor;

@SuppressWarnings("all")
public class DeleterForBuilder {

  private static final class ImmutableDeleterFor implements DeleterFor {

    private final String value;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.DeleterFor.class;
    }

    public final String value () {
      return value;
    }

    private ImmutableDeleterFor  (String value) {
      this.value = value;
    }

  }

  public static DeleterForBuilder buildDeleterFor () {
    return new DeleterForBuilder();
  }

  private String value;

  public final String getValue () {
    return value;
  }

  public final DeleterForBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  private DeleterForBuilder  () {
  }

  public DeleterFor build () {
    return new ImmutableDeleterFor(value);
  }

}
