package xapi.annotation.model;

import xapi.annotation.model.GetterFor;

@SuppressWarnings("all")
public class GetterForBuilder {

  private static final class ImmutableGetterFor implements GetterFor {

    private final String value;

    public Class<? extends java.lang.annotation.Annotation> annotationType () {
      return xapi.annotation.model.GetterFor.class;
    }

    public final String value () {
      return value;
    }

    private ImmutableGetterFor  (String value) {
      this.value = value;
    }

  }

  public static GetterForBuilder buildGetterFor () {
    return new GetterForBuilder();
  }

  private String value;

  public final String getValue () {
    return value;
  }

  public final GetterForBuilder setValue (String value) {
    this.value = value;
    return this;
  }

  private GetterForBuilder  () {
  }

  public GetterFor build () {
    return new ImmutableGetterFor(value);
  }

}
